/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.search;

import java.io.IOException;
import org.apache.lucene.search.CheckedIntConsumer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DocIdStream;
import org.apache.lucene.search.FilterDocIdSetIterator;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.tests.search.AssertingScorable;
import org.apache.lucene.util.FixedBitSet;

class AssertingLeafCollector
extends FilterLeafCollector {
    private final int min;
    private final int max;
    private int lastCollected = -1;
    private boolean finishCalled;

    AssertingLeafCollector(LeafCollector collector, int min, int max) {
        super(collector);
        this.min = min;
        this.max = max;
    }

    public void setScorer(Scorable scorer) throws IOException {
        super.setScorer(AssertingScorable.wrap(scorer));
    }

    public void collect(DocIdStream stream) throws IOException {
        this.in.collect((DocIdStream)new AssertingDocIdStream(stream));
    }

    public void collectRange(int min, int max) throws IOException {
        assert (min > this.lastCollected);
        assert (max > min);
        assert (min >= this.min) : "Out of range: " + min + " < " + this.min;
        assert (max <= this.max) : "Out of range: " + (max - 1) + " >= " + this.max;
        this.in.collectRange(min, max);
        this.lastCollected = max - 1;
    }

    public void collect(int doc) throws IOException {
        assert (doc > this.lastCollected) : "Out of order : " + this.lastCollected + " " + doc;
        assert (doc >= this.min) : "Out of range: " + doc + " < " + this.min;
        assert (doc < this.max) : "Out of range: " + doc + " >= " + this.max;
        this.in.collect(doc);
        this.lastCollected = doc;
    }

    public DocIdSetIterator competitiveIterator() throws IOException {
        DocIdSetIterator in = this.in.competitiveIterator();
        if (in == null) {
            return null;
        }
        return new FilterDocIdSetIterator(in){

            public int nextDoc() throws IOException {
                assert (this.in.docID() < AssertingLeafCollector.this.max) : "advancing beyond the end of the scored window: docID=" + this.in.docID() + ", max=" + AssertingLeafCollector.this.max;
                return this.in.nextDoc();
            }

            public int advance(int target) throws IOException {
                assert (target <= AssertingLeafCollector.this.max) : "advancing beyond the end of the scored window: target=" + target + ", max=" + AssertingLeafCollector.this.max;
                return this.in.advance(target);
            }

            public void intoBitSet(int upTo, FixedBitSet bitSet, int offset) throws IOException {
                assert (upTo <= AssertingLeafCollector.this.max) : "advancing beyond the end of the scored window: upTo=" + upTo + ", max=" + AssertingLeafCollector.this.max;
                this.in.intoBitSet(upTo, bitSet, offset);
                assert (this.in.docID() >= upTo);
            }

            public int docIDRunEnd() throws IOException {
                assert (this.docID() != -1);
                assert (this.docID() != Integer.MAX_VALUE);
                int nextNonMatchingDocID = this.in.docIDRunEnd();
                assert (nextNonMatchingDocID > this.docID());
                return nextNonMatchingDocID;
            }
        };
    }

    public void finish() throws IOException {
        assert (!this.finishCalled);
        this.finishCalled = true;
        super.finish();
    }

    private class AssertingDocIdStream
    extends DocIdStream {
        private final DocIdStream stream;
        private int lastUpTo = -1;

        AssertingDocIdStream(DocIdStream stream) {
            this.stream = stream;
        }

        public void forEach(CheckedIntConsumer<IOException> consumer) throws IOException {
            assert (this.lastUpTo != Integer.MAX_VALUE) : "exhausted";
            this.stream.forEach(doc -> {
                assert (doc > AssertingLeafCollector.this.lastCollected) : "Out of order : " + AssertingLeafCollector.this.lastCollected + " " + doc;
                assert (doc >= AssertingLeafCollector.this.min) : "Out of range: " + doc + " < " + AssertingLeafCollector.this.min;
                assert (doc < AssertingLeafCollector.this.max) : "Out of range: " + doc + " >= " + AssertingLeafCollector.this.max;
                consumer.accept(doc);
                AssertingLeafCollector.this.lastCollected = doc;
            });
            this.lastUpTo = Integer.MAX_VALUE;
            assert (!this.stream.mayHaveRemaining());
        }

        public void forEach(int upTo, CheckedIntConsumer<IOException> consumer) throws IOException {
            assert (this.lastUpTo < upTo) : "upTo=" + upTo + " but previous upTo=" + this.lastUpTo;
            this.stream.forEach(doc -> {
                assert (doc > AssertingLeafCollector.this.lastCollected) : "Out of order : " + AssertingLeafCollector.this.lastCollected + " " + doc;
                assert (doc >= AssertingLeafCollector.this.min) : "Out of range: " + doc + " < " + AssertingLeafCollector.this.min;
                assert (doc < AssertingLeafCollector.this.max) : "Out of range: " + doc + " >= " + AssertingLeafCollector.this.max;
                consumer.accept(doc);
                AssertingLeafCollector.this.lastCollected = doc;
            });
            this.lastUpTo = upTo;
            if (upTo == Integer.MAX_VALUE) assert (!this.stream.mayHaveRemaining());
        }

        public int count() throws IOException {
            assert (this.lastUpTo != Integer.MAX_VALUE) : "exhausted";
            int count = this.stream.count();
            this.lastUpTo = Integer.MAX_VALUE;
            assert (!this.stream.mayHaveRemaining());
            return count;
        }

        public int count(int upTo) throws IOException {
            assert (this.lastUpTo < upTo) : "upTo=" + upTo + " but previous upTo=" + this.lastUpTo;
            int count = this.stream.count(upTo);
            this.lastUpTo = upTo;
            if (upTo == Integer.MAX_VALUE) assert (!this.stream.mayHaveRemaining());
            return count;
        }

        public boolean mayHaveRemaining() {
            boolean mayHaveRemaining = this.stream.mayHaveRemaining();
            if (this.lastUpTo == Integer.MAX_VALUE) assert (!mayHaveRemaining);
            return mayHaveRemaining;
        }
    }
}

