/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components.dialog.analysis;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.lucene.analysis.CharFilterFactory;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenizerFactory;
import org.apache.lucene.analysis.custom.CustomAnalyzer;
import org.apache.lucene.luke.app.desktop.Preferences;
import org.apache.lucene.luke.app.desktop.PreferencesFactory;
import org.apache.lucene.luke.app.desktop.util.DialogOpener;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;

public class AnalysisChainDialogFactory
implements DialogOpener.DialogFactory {
    private static AnalysisChainDialogFactory instance;
    private final Preferences prefs = PreferencesFactory.getInstance();
    private JDialog dialog;
    private CustomAnalyzer analyzer;

    public static synchronized AnalysisChainDialogFactory getInstance() throws IOException {
        if (instance == null) {
            instance = new AnalysisChainDialogFactory();
        }
        return instance;
    }

    private AnalysisChainDialogFactory() throws IOException {
    }

    public void setAnalyzer(CustomAnalyzer analyzer) {
        this.analyzer = analyzer;
    }

    @Override
    public JDialog create(Window owner, String title, int width, int height) {
        this.dialog = new JDialog(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog.add(this.content());
        this.dialog.setSize(new Dimension(width, height));
        this.dialog.setLocationRelativeTo(owner);
        this.dialog.getContentPane().setBackground(this.prefs.getColorTheme().getBackgroundColor());
        return this.dialog;
    }

    private JPanel content() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)this.analysisChain(), "First");
        JPanel footer = new JPanel(new FlowLayout(4, 10, 5));
        footer.setOpaque(false);
        JButton closeBtn = new JButton(MessageUtils.getLocalizedMessage("button.close"));
        closeBtn.addActionListener(e -> this.dialog.dispose());
        footer.add(closeBtn);
        panel.add((Component)footer, "Last");
        return panel;
    }

    private JPanel analysisChain() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.1;
        c.weighty = 0.5;
        panel.add((Component)new JLabel(MessageUtils.getLocalizedMessage("analysis.dialog.chain.label.charfilters")), c);
        String[] charFilters = (String[])this.analyzer.getCharFilterFactories().stream().map(f -> CharFilterFactory.findSPIName(f.getClass())).toArray(String[]::new);
        JList<String> charFilterList = new JList<String>(charFilters);
        charFilterList.setVisibleRowCount(charFilters.length == 0 ? 1 : Math.min(charFilters.length, 5));
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.5;
        c.weighty = 0.5;
        panel.add((Component)new JScrollPane(charFilterList), c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.1;
        c.weighty = 0.1;
        panel.add((Component)new JLabel(MessageUtils.getLocalizedMessage("analysis.dialog.chain.label.tokenizer")), c);
        String tokenizer = TokenizerFactory.findSPIName(this.analyzer.getTokenizerFactory().getClass());
        JTextField tokenizerTF = new JTextField(tokenizer);
        tokenizerTF.setColumns(30);
        tokenizerTF.setEditable(false);
        tokenizerTF.setPreferredSize(new Dimension(300, 25));
        tokenizerTF.setBorder(BorderFactory.createLineBorder(Color.gray));
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 0.5;
        c.weighty = 0.1;
        panel.add((Component)tokenizerTF, c);
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.1;
        c.weighty = 0.5;
        panel.add((Component)new JLabel(MessageUtils.getLocalizedMessage("analysis.dialog.chain.label.tokenfilters")), c);
        String[] tokenFilters = (String[])this.analyzer.getTokenFilterFactories().stream().map(f -> TokenFilterFactory.findSPIName(f.getClass())).toArray(String[]::new);
        JList<String> tokenFilterList = new JList<String>(tokenFilters);
        tokenFilterList.setVisibleRowCount(tokenFilters.length == 0 ? 1 : Math.min(tokenFilters.length, 5));
        tokenFilterList.setMinimumSize(new Dimension(300, 25));
        c.gridx = 1;
        c.gridy = 2;
        c.weightx = 0.5;
        c.weighty = 0.5;
        panel.add((Component)new JScrollPane(tokenFilterList), c);
        return panel;
    }
}

