/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.jmh;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.sandbox.facet.plain.histograms.HistogramCollectorManager;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.util.NumericUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Thread)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=1, warmups=1)
@Warmup(iterations=1, time=1)
@Measurement(iterations=3, time=3)
public class HistogramCollectorBenchmark {
    Directory dir;
    IndexReader reader;
    Path path;

    @Setup(value=Level.Trial)
    public void setup(BenchmarkParams params) throws Exception {
        this.path = Files.createTempDirectory("forUtil", new FileAttribute[0]);
        FSDirectory dir = MMapDirectory.open((Path)this.path);
        IndexWriter w = new IndexWriter((Directory)dir, new IndexWriterConfig());
        Random r = new Random(0L);
        for (int i = 0; i < params.docCount; ++i) {
            Document doc = new Document();
            long value = r.nextInt(0, params.docCount);
            if (params.pointEnabled) {
                doc.add((IndexableField)new LongPoint("f", new long[]{value}));
            } else {
                doc.add((IndexableField)NumericDocValuesField.indexedField((String)"f", (long)value));
            }
            w.addDocument((Iterable)doc);
        }
        w.forceMerge(1, true);
        this.reader = DirectoryReader.open((IndexWriter)w);
        w.close();
    }

    @TearDown(value=Level.Trial)
    public void tearDown() throws Exception {
        this.reader.close();
        if (this.dir != null) {
            this.dir.close();
            this.dir = null;
        }
        if (Files.exists(this.path, new LinkOption[0])) {
            try (Stream<Path> walk = Files.walk(this.path, new FileVisitOption[0]);){
                walk.sorted(Comparator.reverseOrder()).forEach(path -> {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
            }
        }
    }

    @Benchmark
    public void matchAllQueryHistogram(BenchmarkParams params) throws IOException {
        IndexSearcher searcher = new IndexSearcher(this.reader);
        searcher.search((Query)new MatchAllDocsQuery(), (CollectorManager)new HistogramCollectorManager("f", params.bucketWidth, 10000));
    }

    @Benchmark
    public void pointRangeQueryHistogram(BenchmarkParams params) throws IOException {
        IndexSearcher searcher = new IndexSearcher(this.reader);
        Random r = new Random(0L);
        int lowerBound = r.nextInt(params.docCount / 4, 3 * params.docCount / 4);
        int upperBound = lowerBound + params.docCount / 10;
        if (params.pointEnabled) {
            byte[] lowerPoint = new byte[8];
            byte[] upperPoint = new byte[8];
            NumericUtils.longToSortableBytes((long)lowerBound, (byte[])lowerPoint, (int)0);
            NumericUtils.longToSortableBytes((long)upperBound, (byte[])upperPoint, (int)0);
            PointRangeQuery prq = new PointRangeQuery(this, "f", lowerPoint, upperPoint, 1){

                protected String toString(int dimension, byte[] value) {
                    return Long.toString(NumericUtils.sortableBytesToLong((byte[])value, (int)0));
                }
            };
            searcher.search((Query)prq, (CollectorManager)new HistogramCollectorManager("f", params.bucketWidth));
        } else {
            searcher.search(NumericDocValuesField.newSlowRangeQuery((String)"f", (long)lowerBound, (long)upperBound), (CollectorManager)new HistogramCollectorManager("f", params.bucketWidth));
        }
    }

    @State(value=Scope.Benchmark)
    public static class BenchmarkParams {
        @Param(value={"true", "false"})
        public boolean pointEnabled;
        @Param(value={"500000", "5000000"})
        public int docCount;
        @Param(value={"5000", "25000"})
        public long bucketWidth;
    }
}

