/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.facetset;

import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.facet.facetset.FacetSet;
import org.apache.lucene.util.BytesRef;

public class FacetSetsField
extends BinaryDocValuesField {
    public static FacetSetsField create(String name, FacetSet ... facetSets) {
        if (facetSets == null || facetSets.length == 0) {
            throw new IllegalArgumentException("FacetSets cannot be null or empty!");
        }
        return new FacetSetsField(name, FacetSetsField.toPackedValues(facetSets));
    }

    private FacetSetsField(String name, BytesRef value) {
        super(name, value);
    }

    private static BytesRef toPackedValues(FacetSet ... facetSets) {
        int numDims = facetSets[0].dims;
        Class<?> expectedClass = facetSets[0].getClass();
        byte[] buf = new byte[4 + facetSets[0].sizePackedBytes() * facetSets.length];
        IntPoint.encodeDimension((int)numDims, (byte[])buf, (int)0);
        int offset = 4;
        for (FacetSet facetSet : facetSets) {
            if (facetSet.dims != numDims) {
                throw new IllegalArgumentException("All FacetSets must have the same number of dimensions. Expected " + numDims + " found " + facetSet.dims);
            }
            if (facetSet.getClass() != expectedClass) {
                throw new IllegalArgumentException("All FacetSets must be the same type. Expected " + String.valueOf(expectedClass) + " found " + String.valueOf(facetSet.getClass()));
            }
            offset += facetSet.packValues(buf, offset);
        }
        return new BytesRef(buf, 0, offset);
    }
}

