/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.api.services.LookupException;

public class ProtoLookup
implements Lookup {
    private final Map<Class<?>, Object> components;

    private ProtoLookup(Map<Class<?>, Object> components) {
        this.components = components;
    }

    public <T> T lookup(Class<T> type) {
        Optional<T> optional = this.lookupOptional(type);
        if (optional.isPresent()) {
            return optional.get();
        }
        throw new LookupException("No mapping for key: " + type.getName());
    }

    public <T> T lookup(Class<T> type, String name) {
        return this.lookup(type);
    }

    public <T> Optional<T> lookupOptional(Class<T> type) {
        return Optional.ofNullable(type.cast(this.components.get(type)));
    }

    public <T> Optional<T> lookupOptional(Class<T> type, String name) {
        return this.lookupOptional(type);
    }

    public <T> List<T> lookupList(Class<T> type) {
        return List.of();
    }

    public <T> Map<String, T> lookupMap(Class<T> type) {
        return Map.of();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<Class<?>, Object> components = new HashMap();

        public ProtoLookup build() {
            return new ProtoLookup(this.components);
        }

        public <T> Builder addMapping(Class<T> type, T component) {
            Objects.requireNonNull(type, "type");
            Objects.requireNonNull(component, "component");
            if (this.components.put(type, component) != null) {
                throw new IllegalStateException("Duplicate mapping for type: " + type.getName());
            }
            return this;
        }
    }
}

