/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.filters;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.apache.sshd.common.random.Random;

enum ThreadLocalRandom implements Random
{
    INSTANCE;


    @Override
    public String getName() {
        return "ThreadLocalRandom";
    }

    @Override
    public void fill(byte[] bytes, int start, int len) {
        int l;
        java.util.concurrent.ThreadLocalRandom rnd = java.util.concurrent.ThreadLocalRandom.current();
        int n = len / 4;
        if (n > 0) {
            IntBuffer buf = ByteBuffer.wrap(bytes, start, len).asIntBuffer();
            rnd.ints(n).forEach(buf::put);
        }
        if ((l = len & 3) > 0) {
            int x = rnd.nextInt();
            int pos = start + len - 1;
            for (int i = 0; i < l; ++i) {
                bytes[pos - i] = (byte)(x & 0xFF);
                x >>= 8;
            }
        }
    }

    @Override
    public int random(int n) {
        return java.util.concurrent.ThreadLocalRandom.current().nextInt(n);
    }
}

