/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.lifecycle;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicLong;

class TokenGenerator {
    private final AtomicLong _count = new AtomicLong(TokenGenerator._getSeed());

    private static long _getSeed() {
        SecureRandom rng;
        try {
            rng = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            rng = new SecureRandom();
        }
        byte[] randomBytes = new byte[6];
        rng.nextBytes(randomBytes);
        return new BigInteger(randomBytes).longValue();
    }

    String _getNextToken() {
        long nextToken = this._count.incrementAndGet();
        return Long.toString(nextToken, 36);
    }
}

