/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.protocol.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.remote.AbstractTransaction;
import org.apache.nifi.remote.Peer;
import org.apache.nifi.remote.Transaction;
import org.apache.nifi.remote.TransferDirection;
import org.apache.nifi.remote.codec.StandardFlowFileCodec;
import org.apache.nifi.remote.io.http.HttpCommunicationsSession;
import org.apache.nifi.remote.protocol.Response;
import org.apache.nifi.remote.protocol.ResponseCode;
import org.apache.nifi.remote.util.SiteToSiteRestApiClient;
import org.apache.nifi.web.api.entity.TransactionResultEntity;

public class HttpClientTransaction
extends AbstractTransaction {
    private SiteToSiteRestApiClient apiClient;
    private String transactionUrl;

    public HttpClientTransaction(int protocolVersion, Peer peer, TransferDirection direction, boolean useCompression, String portId, int penaltyMillis, EventReporter eventReporter) throws IOException {
        super(peer, direction, useCompression, new StandardFlowFileCodec(), eventReporter, protocolVersion, penaltyMillis, portId);
    }

    public void initialize(SiteToSiteRestApiClient apiUtil, String transactionUrl) throws IOException {
        this.transactionUrl = transactionUrl;
        this.apiClient = apiUtil;
        if (TransferDirection.RECEIVE.equals((Object)this.direction)) {
            this.dataAvailable = apiUtil.openConnectionForReceive(transactionUrl, this.peer);
        } else {
            apiUtil.openConnectionForSend(transactionUrl, this.peer);
        }
    }

    @Override
    protected Response readTransactionResponse() throws IOException {
        HttpCommunicationsSession commSession = (HttpCommunicationsSession)this.peer.getCommunicationsSession();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        if (TransferDirection.RECEIVE.equals((Object)this.direction)) {
            switch (this.state) {
                case TRANSACTION_STARTED: 
                case DATA_EXCHANGED: {
                    this.logger.debug("{} {} readTransactionResponse. checksum={}", new Object[]{this, this.peer, commSession.getChecksum()});
                    if (StringUtils.isEmpty((CharSequence)commSession.getChecksum())) {
                        ResponseCode.CONTINUE_TRANSACTION.writeResponse(dos);
                        break;
                    }
                    if (Transaction.TransactionState.TRANSACTION_STARTED.equals((Object)this.state)) {
                        this.logger.debug("{} {} There's no transaction to confirm.", (Object)this, (Object)this.peer);
                        ResponseCode.CONFIRM_TRANSACTION.writeResponse(dos, "");
                        break;
                    }
                    TransactionResultEntity transactionResult = this.apiClient.commitReceivingFlowFiles(this.transactionUrl, ResponseCode.CONFIRM_TRANSACTION, commSession.getChecksum());
                    ResponseCode responseCode = ResponseCode.fromCode(transactionResult.getResponseCode());
                    if (responseCode.containsMessage()) {
                        String message = transactionResult.getMessage();
                        responseCode.writeResponse(dos, message == null ? "" : message);
                        break;
                    }
                    responseCode.writeResponse(dos);
                }
            }
        } else {
            switch (this.state) {
                case DATA_EXCHANGED: {
                    this.apiClient.finishTransferFlowFiles(commSession);
                    ResponseCode.CONFIRM_TRANSACTION.writeResponse(dos, commSession.getChecksum());
                    break;
                }
                case TRANSACTION_CONFIRMED: {
                    TransactionResultEntity resultEntity = this.apiClient.commitTransferFlowFiles(this.transactionUrl, ResponseCode.CONFIRM_TRANSACTION);
                    ResponseCode responseCode = ResponseCode.fromCode(resultEntity.getResponseCode());
                    if (responseCode.containsMessage()) {
                        responseCode.writeResponse(dos, resultEntity.getMessage());
                        break;
                    }
                    responseCode.writeResponse(dos);
                }
            }
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        return Response.read(new DataInputStream(bis));
    }

    @Override
    protected void writeTransactionResponse(ResponseCode response, String explanation, boolean flush) throws IOException {
        HttpCommunicationsSession commSession = (HttpCommunicationsSession)this.peer.getCommunicationsSession();
        if (TransferDirection.RECEIVE.equals((Object)this.direction)) {
            switch (response) {
                case CONFIRM_TRANSACTION: {
                    this.logger.debug("{} Confirming transaction. checksum={}", (Object)this, (Object)explanation);
                    commSession.setChecksum(explanation);
                    break;
                }
                case TRANSACTION_FINISHED: {
                    this.logger.debug("{} Finishing transaction.", (Object)this);
                    break;
                }
                case CANCEL_TRANSACTION: {
                    this.logger.debug("{} Canceling transaction. explanation={}", (Object)this, (Object)explanation);
                    TransactionResultEntity resultEntity = this.apiClient.commitReceivingFlowFiles(this.transactionUrl, ResponseCode.CANCEL_TRANSACTION, null);
                    ResponseCode cancelResponse = ResponseCode.fromCode(resultEntity.getResponseCode());
                    if (cancelResponse == ResponseCode.CANCEL_TRANSACTION) {
                        this.logger.debug("{} CANCEL_TRANSACTION, The transaction is canceled on server properly.", (Object)this);
                        break;
                    }
                    this.logger.warn("{} CANCEL_TRANSACTION, Expected the transaction is canceled on server, but received {}.", (Object)this, (Object)cancelResponse);
                }
            }
        } else {
            switch (response) {
                case FINISH_TRANSACTION: {
                    this.logger.debug("{} Finished sending flow files.", (Object)this);
                    break;
                }
                case BAD_CHECKSUM: {
                    TransactionResultEntity resultEntity = this.apiClient.commitTransferFlowFiles(this.transactionUrl, ResponseCode.BAD_CHECKSUM);
                    ResponseCode badChecksumCancelResponse = ResponseCode.fromCode(resultEntity.getResponseCode());
                    if (badChecksumCancelResponse == ResponseCode.CANCEL_TRANSACTION) {
                        this.logger.debug("{} BAD_CHECKSUM, The transaction is canceled on server properly.", (Object)this);
                        break;
                    }
                    this.logger.warn("{} BAD_CHECKSUM, Expected the transaction is canceled on server, but received {}.", (Object)this, (Object)badChecksumCancelResponse);
                    break;
                }
                case CONFIRM_TRANSACTION: {
                    this.logger.debug("{} Transaction is confirmed.", (Object)this);
                    break;
                }
                case CANCEL_TRANSACTION: {
                    this.logger.debug("{} Canceling transaction.", (Object)this);
                    TransactionResultEntity resultEntity = this.apiClient.commitTransferFlowFiles(this.transactionUrl, ResponseCode.CANCEL_TRANSACTION);
                    ResponseCode cancelResponse = ResponseCode.fromCode(resultEntity.getResponseCode());
                    if (cancelResponse == ResponseCode.CANCEL_TRANSACTION) {
                        this.logger.debug("{} CANCEL_TRANSACTION, The transaction is canceled on server properly.", (Object)this);
                        break;
                    }
                    this.logger.warn("{} CANCEL_TRANSACTION, Expected the transaction is canceled on server, but received {}.", (Object)this, (Object)cancelResponse);
                }
            }
        }
    }

    @Override
    protected void close() throws IOException {
        if (this.apiClient != null) {
            this.apiClient.close();
        }
    }
}

