/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization;

import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.api.data.ServiceDocument;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.domain.ClientEntitySet;
import org.apache.olingo.client.api.domain.ClientEntitySetIterator;
import org.apache.olingo.client.api.domain.ClientProperty;
import org.apache.olingo.client.api.domain.ClientServiceDocument;
import org.apache.olingo.client.api.domain.ClientValue;
import org.apache.olingo.client.api.edm.xml.XMLMetadata;
import org.apache.olingo.client.api.serialization.ODataDeserializerException;
import org.apache.olingo.client.api.serialization.ODataReader;
import org.apache.olingo.client.core.edm.ClientCsdlEdmProvider;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.ex.ODataError;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.core.edm.EdmProviderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODataReaderImpl
implements ODataReader {
    protected static final Logger LOG = LoggerFactory.getLogger(ODataReaderImpl.class);
    protected final ODataClient client;

    public ODataReaderImpl(ODataClient client) {
        this.client = client;
    }

    public Edm readMetadata(InputStream input) {
        return this.readMetadata(this.client.getDeserializer(ContentType.APPLICATION_XML).toMetadata(input).getSchemaByNsOrAlias());
    }

    public Edm readMetadata(Map<String, CsdlSchema> xmlSchemas) {
        ClientCsdlEdmProvider prov = new ClientCsdlEdmProvider(xmlSchemas);
        return new EdmProviderImpl((CsdlEdmProvider)prov);
    }

    public ClientServiceDocument readServiceDocument(InputStream input, ContentType contentType) throws ODataDeserializerException {
        return this.client.getBinder().getODataServiceDocument((ServiceDocument)this.client.getDeserializer(contentType).toServiceDocument(input).getPayload());
    }

    public ODataError readError(InputStream inputStream, ContentType contentType) throws ODataDeserializerException {
        return this.client.getDeserializer(contentType).toError(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ResWrap<T> read(InputStream src, String format, Class<T> reference) throws ODataDeserializerException {
        ResWrap res;
        block14: {
            try {
                if (ClientEntitySetIterator.class.isAssignableFrom(reference)) {
                    res = new ResWrap((URI)null, null, reference.cast(new ClientEntitySetIterator(this.client, src, ContentType.parse((String)format))));
                    break block14;
                }
                if (ClientEntitySet.class.isAssignableFrom(reference)) {
                    ResWrap resource = this.client.getDeserializer(ContentType.parse((String)format)).toEntitySet(src);
                    res = new ResWrap(resource.getContextURL(), resource.getMetadataETag(), reference.cast(this.client.getBinder().getODataEntitySet(resource)));
                    break block14;
                }
                if (ClientEntity.class.isAssignableFrom(reference)) {
                    ResWrap container = this.client.getDeserializer(ContentType.parse((String)format)).toEntity(src);
                    res = new ResWrap(container.getContextURL(), container.getMetadataETag(), reference.cast(this.client.getBinder().getODataEntity(container)));
                    break block14;
                }
                if (ClientProperty.class.isAssignableFrom(reference)) {
                    ResWrap container = this.client.getDeserializer(ContentType.parse((String)format)).toProperty(src);
                    res = new ResWrap(container.getContextURL(), container.getMetadataETag(), reference.cast(this.client.getBinder().getODataProperty(container)));
                    break block14;
                }
                if (ClientValue.class.isAssignableFrom(reference)) {
                    res = new ResWrap((URI)null, null, reference.cast(this.client.getObjectFactory().newPrimitiveValueBuilder().setType(ContentType.parse((String)format).equals((Object)ContentType.TEXT_PLAIN) ? EdmPrimitiveTypeKind.String : EdmPrimitiveTypeKind.Stream).setValue((Object)IOUtils.toString((InputStream)src)).build()));
                    break block14;
                }
                if (XMLMetadata.class.isAssignableFrom(reference)) {
                    res = new ResWrap((URI)null, null, reference.cast(this.readMetadata(src)));
                    break block14;
                }
                if (ClientServiceDocument.class.isAssignableFrom(reference)) {
                    ResWrap resource = this.client.getDeserializer(ContentType.parse((String)format)).toServiceDocument(src);
                    res = new ResWrap(resource.getContextURL(), resource.getMetadataETag(), reference.cast(this.client.getBinder().getODataServiceDocument((ServiceDocument)resource.getPayload())));
                    break block14;
                }
                if (ODataError.class.isAssignableFrom(reference)) {
                    res = new ResWrap((URI)null, null, reference.cast(this.readError(src, ContentType.parse((String)format))));
                    break block14;
                }
                throw new IllegalArgumentException("Invalid reference type " + reference);
            }
            catch (Exception e) {
                LOG.warn("Cast error", (Throwable)e);
                res = null;
            }
            finally {
                if (!ClientEntitySetIterator.class.isAssignableFrom(reference)) {
                    IOUtils.closeQuietly((InputStream)src);
                }
            }
        }
        return res;
    }

    public ClientEntitySet readEntitySet(InputStream input, ContentType contentType) throws ODataDeserializerException {
        return this.client.getBinder().getODataEntitySet(this.client.getDeserializer(contentType).toEntitySet(input));
    }

    public ClientEntity readEntity(InputStream input, ContentType contentType) throws ODataDeserializerException {
        return this.client.getBinder().getODataEntity(this.client.getDeserializer(contentType).toEntity(input));
    }

    public ClientProperty readProperty(InputStream input, ContentType contentType) throws ODataDeserializerException {
        return this.client.getBinder().getODataProperty(this.client.getDeserializer(contentType).toProperty(input));
    }

    public Edm readMetadata(InputStream input, List<InputStream> termDefinitions) {
        return this.readMetadata(this.client.getDeserializer(ContentType.APPLICATION_XML).toMetadata(input).getSchemaByNsOrAlias(), this.client.getDeserializer(ContentType.APPLICATION_XML).fetchTermDefinitionSchema(termDefinitions));
    }

    public Edm readMetadata(Map<String, CsdlSchema> xmlSchemas, List<CsdlSchema> termDefinitionSchema) {
        ClientCsdlEdmProvider prov = new ClientCsdlEdmProvider(xmlSchemas);
        return new EdmProviderImpl((CsdlEdmProvider)prov, termDefinitionSchema);
    }

    public Edm readMetadata(XMLMetadata metadata, List<InputStream> termDefinitions) {
        return this.readMetadata(metadata.getSchemaByNsOrAlias(), this.client.getDeserializer(ContentType.APPLICATION_XML).fetchTermDefinitionSchema(termDefinitions));
    }
}

