/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum BACnetRelationship {
  UNKNOWN((int) 0),
  DEFAULT((int) 1),
  CONTAINS((int) 2),
  CONTAINED_BY((int) 3),
  USES((int) 4),
  USED_BY((int) 5),
  COMMANDS((int) 6),
  COMMANDED_BY((int) 7),
  ADJUSTS((int) 8),
  ADJUSTED_BY((int) 9),
  INGRESS((int) 10),
  EGRESS((int) 11),
  SUPPLIES_AIR((int) 12),
  RECEIVES_AIR((int) 13),
  SUPPLIES_HOT_AIR((int) 14),
  RECEIVES_HOT_AIR((int) 15),
  SUPPLIES_COOL_AIR((int) 16),
  RECEIVES_COOL_AIR((int) 17),
  SUPPLIES_POWER((int) 18),
  RECEIVES_POWER((int) 19),
  SUPPLIES_GAS((int) 20),
  RECEIVES_GAS((int) 21),
  SUPPLIES_WATER((int) 22),
  RECEIVES_WATER((int) 23),
  SUPPLIES_HOT_WATER((int) 24),
  RECEIVES_HOT_WATER((int) 25),
  SUPPLIES_COOL_WATER((int) 26),
  RECEIVES_COOL_WATER((int) 27),
  SUPPLIES_STEAM((int) 28),
  RECEIVES_STEAM((int) 29),
  VENDOR_PROPRIETARY_VALUE((int) 0XFFFF);
  private static final Map<Integer, BACnetRelationship> map;

  static {
    map = new HashMap<>();
    for (BACnetRelationship value : BACnetRelationship.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private final int value;

  BACnetRelationship(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static BACnetRelationship enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
