/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class FindServersResponse extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 425;
  }

  // Properties.
  protected final ResponseHeader responseHeader;
  protected final List<ApplicationDescription> servers;

  public FindServersResponse(ResponseHeader responseHeader, List<ApplicationDescription> servers) {
    super();
    this.responseHeader = responseHeader;
    this.servers = servers;
  }

  public ResponseHeader getResponseHeader() {
    return responseHeader;
  }

  public List<ApplicationDescription> getServers() {
    return servers;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("FindServersResponse");

    // Simple Field (responseHeader)
    writeSimpleField("responseHeader", responseHeader, writeComplex(writeBuffer));

    // Implicit Field (noOfServers) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfServers = (int) ((((getServers()) == (null)) ? -(1) : COUNT(getServers())));
    writeImplicitField("noOfServers", noOfServers, writeSignedInt(writeBuffer, 32));

    // Array Field (servers)
    writeComplexTypeArrayField("servers", servers, writeBuffer);

    writeBuffer.popContext("FindServersResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    FindServersResponse _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (responseHeader)
    lengthInBits += responseHeader.getLengthInBits();

    // Implicit Field (noOfServers)
    lengthInBits += 32;

    // Array field
    if (servers != null) {
      int i = 0;
      for (ApplicationDescription element : servers) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= servers.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("FindServersResponse");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    ResponseHeader responseHeader =
        readSimpleField(
            "responseHeader",
            readComplex(
                () ->
                    (ResponseHeader) ExtensionObjectDefinition.staticParse(readBuffer, (int) (394)),
                readBuffer));

    int noOfServers = readImplicitField("noOfServers", readSignedInt(readBuffer, 32));

    List<ApplicationDescription> servers =
        readCountArrayField(
            "servers",
            readComplex(
                () ->
                    (ApplicationDescription)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (310)),
                readBuffer),
            noOfServers);

    readBuffer.closeContext("FindServersResponse");
    // Create the instance
    return new FindServersResponseBuilderImpl(responseHeader, servers);
  }

  public static class FindServersResponseBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final ResponseHeader responseHeader;
    private final List<ApplicationDescription> servers;

    public FindServersResponseBuilderImpl(
        ResponseHeader responseHeader, List<ApplicationDescription> servers) {
      this.responseHeader = responseHeader;
      this.servers = servers;
    }

    public FindServersResponse build() {
      FindServersResponse findServersResponse = new FindServersResponse(responseHeader, servers);
      return findServersResponse;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof FindServersResponse)) {
      return false;
    }
    FindServersResponse that = (FindServersResponse) o;
    return (getResponseHeader() == that.getResponseHeader())
        && (getServers() == that.getServers())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getResponseHeader(), getServers());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
