/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.proxy.command;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.InputStreamEntity;
import org.apache.portals.applications.webcontent2.proxy.ProxyContext;
import org.apache.portals.applications.webcontent2.proxy.ReverseProxyException;
import org.apache.portals.applications.webcontent2.proxy.impl.AbstractProxyCommand;

public class InitHttpRequestCommand
extends AbstractProxyCommand {
    @Override
    protected boolean executeInternal(ProxyContext context) throws ReverseProxyException, IOException {
        HttpRequestBase httpRequest = this.createHttpRequest(context);
        context.setHttpRequest(httpRequest);
        return false;
    }

    protected HttpRequestBase createHttpRequest(ProxyContext context) throws ReverseProxyException, IOException {
        HttpGet httpRequest = null;
        String method = context.getRequestContext().getMethod();
        URI remoteURI = context.getRemoteURI();
        if ("GET".equals(method)) {
            httpRequest = new HttpGet(remoteURI);
        } else if ("HEAD".equals(method)) {
            httpRequest = new HttpHead(remoteURI);
        } else if ("POST".equals(method)) {
            httpRequest = new HttpPost(remoteURI);
            long contentLength = NumberUtils.toLong((String)context.getRequestContext().getHeader("Content-Length"));
            if (contentLength > 0L) {
                InputStreamEntity entity = new InputStreamEntity(context.getRequestContext().getInputStream(), contentLength);
                ((HttpPost)httpRequest).setEntity((HttpEntity)entity);
            }
        } else if ("PUT".equals(method)) {
            httpRequest = new HttpPut(remoteURI);
            long contentLength = NumberUtils.toLong((String)context.getRequestContext().getHeader("Content-Length"));
            if (contentLength > 0L) {
                InputStreamEntity entity = new InputStreamEntity(context.getRequestContext().getInputStream(), contentLength);
                ((HttpPut)httpRequest).setEntity((HttpEntity)entity);
            }
        } else if ("DELETE".equals(method)) {
            httpRequest = new HttpDelete(remoteURI);
        } else if ("OPTIONS".equals(method)) {
            httpRequest = new HttpOptions(remoteURI);
        } else if ("TRACE".equals(method)) {
            httpRequest = new HttpHead(remoteURI);
        } else {
            throw new ReverseProxyException(405, "Unsupported method: " + method);
        }
        return httpRequest;
    }
}

