/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.proxy.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.portals.applications.webcontent2.rewriter.Source;

public class HttpEntitySource
implements Source {
    private final HttpEntity entity;
    private final String characterEncoding;

    public HttpEntitySource(HttpEntity entity) {
        this(entity, null);
    }

    public HttpEntitySource(HttpEntity entity, String characterEncoding) {
        this.entity = entity;
        this.characterEncoding = characterEncoding;
    }

    public InputStream getInputStream() throws IOException {
        return this.entity.getContent();
    }

    public Reader getReader() throws IOException {
        String charsetName = this.characterEncoding;
        if (charsetName == null) {
            ContentType contentType = ContentType.getOrDefault((HttpEntity)this.entity);
            Charset charset = contentType.getCharset();
            String string = charsetName = charset != null ? charset.name() : null;
        }
        if (charsetName != null) {
            return new InputStreamReader(this.getInputStream(), charsetName);
        }
        return new InputStreamReader(this.getInputStream());
    }
}

