/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.proxy.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.chain.impl.ChainBase;
import org.apache.commons.lang.ArrayUtils;
import org.apache.portals.applications.webcontent2.proxy.ProxyContext;
import org.apache.portals.applications.webcontent2.proxy.ReverseProxyException;
import org.apache.portals.applications.webcontent2.proxy.impl.AbstractProxyCommand;

public class ProxyProcessingChain
extends ChainBase {
    public ProxyProcessingChain() {
    }

    public ProxyProcessingChain(Command command) {
        super(command);
    }

    public ProxyProcessingChain(Command[] commands) {
        super(commands);
    }

    public ProxyProcessingChain(Collection commands) {
        super(commands);
    }

    public int getCommandCount() {
        return this.commands.length;
    }

    public int getCommandIndex(Command command) {
        return ArrayUtils.indexOf((Object[])this.commands, (Object)command);
    }

    public int getCommandIndex(Class<? extends Command> commandType) {
        if (this.commands == null) {
            return -1;
        }
        if (commandType == null) {
            return -1;
        }
        for (int i = 0; i < this.commands.length; ++i) {
            if (this.commands[i] == null || !commandType.isAssignableFrom(this.commands[i].getClass())) continue;
            return i;
        }
        return -1;
    }

    public Command getCommand(int index) {
        if (index < 0 || index > this.commands.length) {
            throw new IllegalArgumentException();
        }
        return this.commands[index];
    }

    public void addCommand(int index, Command command) {
        if (index < 0 || index > this.commands.length) {
            throw new IllegalArgumentException();
        }
        if (command == null) {
            throw new IllegalArgumentException();
        }
        if (this.frozen) {
            throw new IllegalStateException();
        }
        Command[] results = new Command[this.commands.length + 1];
        System.arraycopy(this.commands, 0, results, 0, index);
        System.arraycopy(this.commands, index, results, index + 1, this.commands.length - index);
        results[index] = command;
        this.commands = results;
    }

    public boolean removeCommand(int index) {
        if (index < 0 || index > this.commands.length) {
            throw new IllegalArgumentException();
        }
        if (this.frozen) {
            throw new IllegalStateException();
        }
        Command[] results = new Command[this.commands.length - 1];
        System.arraycopy(this.commands, 0, results, 0, index);
        System.arraycopy(this.commands, index + 1, results, index, this.commands.length - index - 1);
        this.commands = results;
        return true;
    }

    public boolean removeCommand(Command command) {
        if (command == null) {
            throw new IllegalArgumentException();
        }
        int index = this.getCommandIndex(command);
        if (index != -1) {
            return this.removeCommand(index);
        }
        return false;
    }

    public boolean execute(Context context) throws ReverseProxyException, IOException {
        try {
            super.execute(context);
        }
        catch (Exception e) {
            ((ProxyContext)context).addException(e);
        }
        return false;
    }

    public List<AbstractProxyCommand> getAllProxyCommands() {
        LinkedList<AbstractProxyCommand> allCommands = new LinkedList<AbstractProxyCommand>();
        this.findDescendantProxyCommands(allCommands);
        return allCommands;
    }

    private void findDescendantProxyCommands(List<AbstractProxyCommand> descendantProxyCommands) {
        if (this.commands != null) {
            for (Command command : this.commands) {
                if (command instanceof AbstractProxyCommand) {
                    descendantProxyCommands.add((AbstractProxyCommand)command);
                    continue;
                }
                if (!(command instanceof ProxyProcessingChain)) continue;
                ((ProxyProcessingChain)command).findDescendantProxyCommands(descendantProxyCommands);
            }
        }
    }
}

