/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.proxy.servlet;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.portals.applications.webcontent2.proxy.ProxyContext;
import org.apache.portals.applications.webcontent2.proxy.ReverseProxyException;
import org.apache.portals.applications.webcontent2.proxy.ReverseProxyService;
import org.apache.portals.applications.webcontent2.proxy.impl.ServletRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericReverseProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Set<String> DEFAULT_ALLOWED_HTTP_METHODS = new HashSet<String>(Arrays.asList("GET", "HEAD", "POST", "PUT", "DELETE", "OPTIONS", "TRACE"));
    private static Logger log = LoggerFactory.getLogger(GenericReverseProxyServlet.class);
    private ReverseProxyService proxyService;

    public ReverseProxyService getProxyService() {
        return this.proxyService;
    }

    public void setProxyService(ReverseProxyService proxyService) {
        this.proxyService = proxyService;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block13: {
            if (!this.isAllowedHttpMethod(request)) {
                super.service(request, response);
            } else {
                try {
                    ServletRequestContext requestContext = new ServletRequestContext(request, response);
                    ProxyContext proxyContext = new ProxyContext(requestContext);
                    ProxyContext.setCurrentProxyContext(proxyContext);
                    this.getProxyService().invoke(proxyContext);
                }
                catch (ReverseProxyException e) {
                    if (e.getStatusCode() > 0) {
                        if (log.isDebugEnabled()) {
                            log.error("Response proxy processing exception occurred.", (Throwable)e);
                        } else {
                            log.error("Response proxy processing exception occurred. " + e);
                        }
                        response.sendError(e.getStatusCode(), e.getLocalizedMessage());
                        break block13;
                    }
                    throw new ServletException((Throwable)e);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
                finally {
                    ProxyContext.removeCurrentProxyContext();
                }
            }
        }
    }

    protected boolean isAllowedHttpMethod(HttpServletRequest request) {
        return DEFAULT_ALLOWED_HTTP_METHODS.contains(request.getMethod());
    }
}

