/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.impl;

import com.google.common.collect.Maps;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.PulsarVersion;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.loadbalance.LeaderBroker;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.conf.InternalConfigurationData;
import org.apache.pulsar.common.naming.TopicVersion;
import org.apache.pulsar.common.policies.data.BrokerInfo;
import org.apache.pulsar.common.policies.data.BrokerOperation;
import org.apache.pulsar.common.policies.data.NamespaceOwnershipStatus;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.ThreadDumpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokersBase
extends AdminResource {
    private static final Logger LOG = LoggerFactory.getLogger(BrokersBase.class);
    private static final long LOG_THREADDUMP_INTERVAL_WHEN_DEADLOCK_DETECTED = 600000L;
    private static volatile long threadDumpLoggedTimestamp;

    @GET
    @Path(value="/{cluster}")
    @ApiOperation(value="Get the list of active brokers (broker ids) in the cluster.If authorization is not enabled, any cluster name is valid.", response=String.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve this cluster"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="This operation requires super-user access"), @ApiResponse(code=404, message="Cluster does not exist: cluster={clustername}")})
    public void getActiveBrokers(@Suspended AsyncResponse asyncResponse, @PathParam(value="cluster") String cluster) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateBothSuperuserAndBrokerOperation(cluster == null ? this.pulsar().getConfiguration().getClusterName() : cluster, this.pulsar().getBrokerId(), BrokerOperation.LIST_BROKERS).thenCompose(__ -> this.validateClusterOwnershipAsync(cluster))).thenCompose(__ -> this.pulsar().getLoadManager().get().getAvailableBrokersAsync())).thenAccept(activeBrokers -> {
            LOG.info("[{}] Successfully to get active brokers, cluster={}", (Object)this.clientAppId(), (Object)cluster);
            asyncResponse.resume(activeBrokers);
        })).exceptionally(ex -> {
            if (!BrokersBase.isRedirectException(ex)) {
                LOG.error("[{}] Fail to get active brokers, cluster={}", new Object[]{this.clientAppId(), cluster, ex});
            }
            BrokersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @GET
    @ApiOperation(value="Get the list of active brokers (broker ids) in the local cluster.If authorization is not enabled", response=String.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="This operation requires super-user access")})
    public void getActiveBrokers(@Suspended AsyncResponse asyncResponse) throws Exception {
        this.getActiveBrokers(asyncResponse, null);
    }

    @GET
    @Path(value="/leaderBroker")
    @ApiOperation(value="Get the information of the leader broker.", response=BrokerInfo.class)
    @ApiResponses(value={@ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="This operation requires super-user access"), @ApiResponse(code=404, message="Leader broker not found")})
    public void getLeaderBroker(@Suspended AsyncResponse asyncResponse) {
        ((CompletableFuture)this.validateBothSuperuserAndBrokerOperation(this.pulsar().getConfig().getClusterName(), this.pulsar().getBrokerId(), BrokerOperation.GET_LEADER_BROKER).thenAccept(__ -> {
            LeaderBroker leaderBroker = this.pulsar().getLeaderElectionService().getCurrentLeader().orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Couldn't find leader broker"));
            BrokerInfo brokerInfo = BrokerInfo.builder().serviceUrl(leaderBroker.getServiceUrl()).brokerId(leaderBroker.getBrokerId()).build();
            LOG.info("[{}] Successfully to get the information of the leader broker.", (Object)this.clientAppId());
            asyncResponse.resume((Object)brokerInfo);
        })).exceptionally(ex -> {
            LOG.error("[{}] Failed to get the information of the leader broker.", (Object)this.clientAppId(), ex);
            BrokersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @GET
    @Path(value="/{clusterName}/{brokerId}/ownedNamespaces")
    @ApiOperation(value="Get the list of namespaces served by the specific broker id", response=NamespaceOwnershipStatus.class, responseContainer="Map")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the cluster"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Cluster doesn't exist")})
    public void getOwnedNamespaces(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterName") String cluster, @PathParam(value="brokerId") String brokerId) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateBothSuperuserAndBrokerOperation(this.pulsar().getConfig().getClusterName(), this.pulsar().getBrokerId(), BrokerOperation.LIST_OWNED_NAMESPACES).thenCompose(__ -> this.maybeRedirectToBroker(brokerId))).thenCompose(__ -> this.validateClusterOwnershipAsync(cluster))).thenCompose(__ -> this.pulsar().getNamespaceService().getOwnedNameSpacesStatusAsync())).thenAccept(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).exceptionally(ex -> {
            if (!BrokersBase.isRedirectException(ex)) {
                LOG.error("[{}] Failed to get the namespace ownership status. cluster={}, broker={}", new Object[]{this.clientAppId(), cluster, brokerId});
            }
            BrokersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @POST
    @Path(value="/configuration/{configName}/{configValue}")
    @ApiOperation(value="Update dynamic serviceconfiguration into zk only. This operation requires Pulsar super-user privileges.")
    @ApiResponses(value={@ApiResponse(code=204, message="Service configuration updated successfully"), @ApiResponse(code=403, message="You don't have admin permission to update service-configuration"), @ApiResponse(code=404, message="Configuration not found"), @ApiResponse(code=412, message="Invalid dynamic-config value"), @ApiResponse(code=500, message="Internal server error")})
    public void updateDynamicConfiguration(@Suspended AsyncResponse asyncResponse, @PathParam(value="configName") String configName, @PathParam(value="configValue") String configValue) {
        ((CompletableFuture)((CompletableFuture)this.validateBothSuperuserAndBrokerOperation(this.pulsar().getConfig().getClusterName(), this.pulsar().getBrokerId(), BrokerOperation.UPDATE_DYNAMIC_CONFIGURATION).thenCompose(__ -> this.persistDynamicConfigurationAsync(configName, configValue))).thenAccept(__ -> {
            LOG.info("[{}] Updated Service configuration {}/{}", new Object[]{this.clientAppId(), configName, configValue});
            asyncResponse.resume((Object)Response.ok().build());
        })).exceptionally(ex -> {
            LOG.error("[{}] Failed to update configuration {}/{}", new Object[]{this.clientAppId(), configName, configValue, ex});
            BrokersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @DELETE
    @Path(value="/configuration/{configName}")
    @ApiOperation(value="Delete dynamic ServiceConfiguration into metadata only. This operation requires Pulsar super-user privileges.")
    @ApiResponses(value={@ApiResponse(code=204, message="Service configuration delete successfully"), @ApiResponse(code=403, message="You don't have admin permission to update service-configuration"), @ApiResponse(code=412, message="Invalid dynamic-config value"), @ApiResponse(code=500, message="Internal server error")})
    public void deleteDynamicConfiguration(@Suspended AsyncResponse asyncResponse, @PathParam(value="configName") String configName) {
        ((CompletableFuture)((CompletableFuture)this.validateBothSuperuserAndBrokerOperation(this.pulsar().getConfig().getClusterName(), this.pulsar().getBrokerId(), BrokerOperation.DELETE_DYNAMIC_CONFIGURATION).thenCompose(__ -> this.internalDeleteDynamicConfigurationOnMetadataAsync(configName))).thenAccept(__ -> {
            LOG.info("[{}] Successfully to delete dynamic configuration {}", (Object)this.clientAppId(), (Object)configName);
            asyncResponse.resume((Object)Response.ok().build());
        })).exceptionally(ex -> {
            LOG.error("[{}] Failed to delete dynamic configuration {}", new Object[]{this.clientAppId(), configName, ex});
            BrokersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @GET
    @Path(value="/configuration/values")
    @ApiOperation(value="Get value of all dynamic configurations' value overridden on local config", response=String.class, responseContainer="Map")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have admin permission to view configuration"), @ApiResponse(code=404, message="Configuration not found"), @ApiResponse(code=500, message="Internal server error")})
    public void getAllDynamicConfigurations(@Suspended AsyncResponse asyncResponse) {
        ((CompletableFuture)((CompletableFuture)this.validateBothSuperuserAndBrokerOperation(this.pulsar().getConfig().getClusterName(), this.pulsar().getBrokerId(), BrokerOperation.LIST_DYNAMIC_CONFIGURATIONS).thenCompose(__ -> this.dynamicConfigurationResources().getDynamicConfigurationAsync())).thenAccept(configOpt -> asyncResponse.resume((Object)configOpt.orElseGet(Collections::emptyMap)))).exceptionally(ex -> {
            LOG.error("[{}] Failed to get all dynamic configuration.", (Object)this.clientAppId(), ex);
            BrokersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @GET
    @Path(value="/configuration")
    @ApiOperation(value="Get all updatable dynamic configurations's name", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have admin permission to get configuration")})
    public void getDynamicConfigurationName(@Suspended AsyncResponse asyncResponse) {
        ((CompletableFuture)this.validateBothSuperuserAndBrokerOperation(this.pulsar().getConfig().getClusterName(), this.pulsar().getBrokerId(), BrokerOperation.LIST_DYNAMIC_CONFIGURATIONS).thenAccept(__ -> asyncResponse.resume(this.pulsar().getBrokerService().getDynamicConfiguration()))).exceptionally(ex -> {
            LOG.error("[{}] Failed to get all dynamic configuration names.", (Object)this.clientAppId(), ex);
            BrokersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @GET
    @Path(value="/configuration/runtime")
    @ApiOperation(value="Get all runtime configurations. This operation requires Pulsar super-user privileges.", response=String.class, responseContainer="Map")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void getRuntimeConfiguration(@Suspended AsyncResponse asyncResponse) {
        ((CompletableFuture)this.validateBothSuperuserAndBrokerOperation(this.pulsar().getConfig().getClusterName(), this.pulsar().getBrokerId(), BrokerOperation.LIST_RUNTIME_CONFIGURATIONS).thenAccept(__ -> asyncResponse.resume(this.pulsar().getBrokerService().getRuntimeConfiguration()))).exceptionally(ex -> {
            LOG.error("[{}] Failed to get runtime configuration.", (Object)this.clientAppId(), ex);
            BrokersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    private synchronized CompletableFuture<Void> persistDynamicConfigurationAsync(String configName, String configValue) {
        if (!this.pulsar().getBrokerService().validateDynamicConfiguration(configName, configValue)) {
            return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, " Invalid dynamic-config value")));
        }
        if (this.pulsar().getBrokerService().isDynamicConfiguration(configName)) {
            return this.dynamicConfigurationResources().setDynamicConfigurationWithCreateAsync(old -> {
                Map configurationMap = old.orElseGet(Maps::newHashMap);
                configurationMap.put(configName, configValue);
                return configurationMap;
            });
        }
        return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Can't update non-dynamic configuration")));
    }

    @GET
    @Path(value="/internal-configuration")
    @ApiOperation(value="Get the internal configuration data", response=InternalConfigurationData.class)
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void getInternalConfigurationData(@Suspended AsyncResponse asyncResponse) {
        ((CompletableFuture)this.validateBothSuperuserAndBrokerOperation(this.pulsar().getConfig().getClusterName(), this.pulsar().getBrokerId(), BrokerOperation.GET_INTERNAL_CONFIGURATION_DATA).thenAccept(__ -> asyncResponse.resume((Object)this.pulsar().getInternalConfigurationData()))).exceptionally(ex -> {
            LOG.error("[{}] Failed to get internal configuration data.", (Object)this.clientAppId(), ex);
            BrokersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @GET
    @Path(value="/backlog-quota-check")
    @ApiOperation(value="An REST endpoint to trigger backlogQuotaCheck")
    @ApiResponses(value={@ApiResponse(code=204, message="Everything is OK"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=500, message="Internal server error")})
    public void backlogQuotaCheck(@Suspended AsyncResponse asyncResponse) {
        ((CompletableFuture)this.validateBothSuperuserAndBrokerOperation(this.pulsar().getConfig().getClusterName(), this.pulsar().getBrokerId(), BrokerOperation.CHECK_BACKLOG_QUOTA).thenAcceptAsync(__ -> {
            this.pulsar().getBrokerService().monitorBacklogQuota();
            asyncResponse.resume((Object)Response.noContent().build());
        }, (Executor)this.pulsar().getBrokerService().getBacklogQuotaChecker())).exceptionally(ex -> {
            LOG.error("[{}] Failed to trigger backlog quota check.", (Object)this.clientAppId(), ex);
            BrokersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @GET
    @Path(value="/ready")
    @ApiOperation(value="Check if the broker is fully initialized")
    @ApiResponses(value={@ApiResponse(code=200, message="Broker is ready"), @ApiResponse(code=500, message="Broker is not ready")})
    public void isReady(@Suspended AsyncResponse asyncResponse) {
        if (this.pulsar().getState() == PulsarService.State.Started) {
            asyncResponse.resume((Object)Response.ok((Object)"ok").build());
        } else {
            asyncResponse.resume((Object)Response.serverError().build());
        }
    }

    @GET
    @Path(value="/health")
    @ApiOperation(value="Run a healthCheck against the broker")
    @ApiResponses(value={@ApiResponse(code=200, message="Everything is OK"), @ApiResponse(code=307, message="Current broker is not the target broker"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Cluster doesn't exist"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Service unavailable")})
    public void healthCheck(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Topic Version") @QueryParam(value="topicVersion") TopicVersion topicVersion, @QueryParam(value="brokerId") String brokerId) {
        if (this.pulsar().getState() == PulsarService.State.Closed || this.pulsar().getState() == PulsarService.State.Closing) {
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build());
            return;
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateBothSuperuserAndBrokerOperation(this.pulsar().getConfig().getClusterName(), StringUtils.isBlank((CharSequence)brokerId) ? this.pulsar().getBrokerId() : brokerId, BrokerOperation.HEALTH_CHECK).thenCompose(__ -> this.maybeRedirectToBroker(StringUtils.isBlank((CharSequence)brokerId) ? this.pulsar().getBrokerId() : brokerId))).thenAccept(__ -> this.checkDeadlockedThreads())).thenCompose(__ -> this.internalRunHealthCheck(topicVersion))).thenAccept(__ -> {
            LOG.info("[{}] Successfully run health check.", (Object)this.clientAppId());
            asyncResponse.resume((Object)Response.ok((Object)"ok").build());
        })).exceptionally(ex -> {
            if (!BrokersBase.isRedirectException(ex)) {
                if (BrokersBase.isNotFoundException(ex)) {
                    LOG.warn("[{}] Failed to run health check: {}", (Object)this.clientAppId(), (Object)ex.getMessage());
                } else {
                    LOG.error("[{}] Failed to run health check.", (Object)this.clientAppId(), ex);
                }
            }
            BrokersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    private void checkDeadlockedThreads() {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        long[] threadIds = threadBean.findDeadlockedThreads();
        if (threadIds != null && threadIds.length > 0) {
            ThreadInfo[] threadInfos = threadBean.getThreadInfo(threadIds, false, false);
            String threadNames = Arrays.stream(threadInfos).map(threadInfo -> threadInfo.getThreadName() + "(tid=" + threadInfo.getThreadId() + ")").collect(Collectors.joining(", "));
            if (System.currentTimeMillis() - threadDumpLoggedTimestamp > 600000L) {
                threadDumpLoggedTimestamp = System.currentTimeMillis();
                LOG.error("Deadlocked threads detected. {}\n{}", (Object)threadNames, (Object)ThreadDumpUtil.buildThreadDiagnosticString());
            } else {
                LOG.error("Deadlocked threads detected. {}", (Object)threadNames);
            }
            throw new IllegalStateException("Deadlocked threads detected. " + threadNames);
        }
    }

    private CompletableFuture<Void> internalRunHealthCheck(TopicVersion topicVersion) {
        return this.pulsar().runHealthCheck(topicVersion, this.clientAppId());
    }

    private CompletableFuture<Void> internalDeleteDynamicConfigurationOnMetadataAsync(String configName) {
        if (!this.pulsar().getBrokerService().isDynamicConfiguration(configName)) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Can't delete non-dynamic configuration");
        }
        return this.dynamicConfigurationResources().setDynamicConfigurationAsync(old -> {
            if (old != null) {
                old.remove(configName);
            }
            return old;
        });
    }

    @GET
    @Path(value="/version")
    @ApiOperation(value="Get version of current broker")
    @ApiResponses(value={@ApiResponse(code=200, message="The Pulsar version", response=String.class), @ApiResponse(code=500, message="Internal server error")})
    public String version() throws Exception {
        return PulsarVersion.getVersion();
    }

    @POST
    @Path(value="/shutdown")
    @ApiOperation(value="Shutdown broker gracefully.")
    @ApiResponses(value={@ApiResponse(code=204, message="Execute shutdown command successfully"), @ApiResponse(code=403, message="You don't have admin permission to update service-configuration"), @ApiResponse(code=500, message="Internal server error")})
    public void shutDownBrokerGracefully(@ApiParam(name="maxConcurrentUnloadPerSec", value="if the value absent(value=0) means no concurrent limitation.") @QueryParam(value="maxConcurrentUnloadPerSec") int maxConcurrentUnloadPerSec, @QueryParam(value="forcedTerminateTopic") @DefaultValue(value="true") boolean forcedTerminateTopic, @Suspended AsyncResponse asyncResponse) {
        ((CompletableFuture)((CompletableFuture)this.validateBothSuperuserAndBrokerOperation(this.pulsar().getConfig().getClusterName(), this.pulsar().getBrokerId(), BrokerOperation.SHUTDOWN).thenCompose(__ -> this.doShutDownBrokerGracefullyAsync(maxConcurrentUnloadPerSec, forcedTerminateTopic))).thenAccept(__ -> {
            LOG.info("[{}] Successfully shutdown broker gracefully", (Object)this.clientAppId());
            asyncResponse.resume((Object)Response.noContent().build());
        })).exceptionally(ex -> {
            LOG.error("[{}] Failed to shutdown broker gracefully", (Object)this.clientAppId(), ex);
            BrokersBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    private CompletableFuture<Void> doShutDownBrokerGracefullyAsync(int maxConcurrentUnloadPerSec, boolean forcedTerminateTopic) {
        this.pulsar().getBrokerService().unloadNamespaceBundlesGracefully(maxConcurrentUnloadPerSec, forcedTerminateTopic);
        return this.pulsar().closeAsync();
    }

    private CompletableFuture<Void> validateBothSuperuserAndBrokerOperation(String cluster, String brokerId, BrokerOperation operation) {
        CompletableFuture<Void> superUserAccessValidation = this.validateSuperUserAccessAsync();
        CompletableFuture<Void> brokerOperationValidation = this.validateBrokerOperationAsync(cluster, brokerId, operation);
        return FutureUtil.waitForAll(List.of(superUserAccessValidation, brokerOperationValidation)).handle((result, err) -> {
            if (!superUserAccessValidation.isCompletedExceptionally() || !brokerOperationValidation.isCompletedExceptionally()) {
                return null;
            }
            if (LOG.isDebugEnabled()) {
                Throwable superUserValidationException = null;
                try {
                    superUserAccessValidation.join();
                }
                catch (Throwable ex) {
                    superUserValidationException = FutureUtil.unwrapCompletionException((Throwable)ex);
                }
                Throwable brokerOperationValidationException = null;
                try {
                    brokerOperationValidation.join();
                }
                catch (Throwable ex) {
                    brokerOperationValidationException = FutureUtil.unwrapCompletionException((Throwable)ex);
                }
                LOG.debug("validateBothSuperuserAndBrokerOperation failed. originalPrincipal={} clientAppId={} operation={} broker={} superuserValidationError={} brokerOperationValidationError={}", new Object[]{this.originalPrincipal(), this.clientAppId(), operation.toString(), brokerId, superUserValidationException, brokerOperationValidationException});
            }
            throw new RestException(Response.Status.UNAUTHORIZED, String.format("Unauthorized to validateBothSuperuserAndBrokerOperation for originalPrincipal [%s] and clientAppId [%s] about operation [%s] on broker [%s]", this.originalPrincipal(), this.clientAppId(), operation.toString(), brokerId));
        });
    }

    private CompletableFuture<Void> validateBrokerOperationAsync(String cluster, String brokerId, BrokerOperation operation) {
        PulsarService pulsar = this.pulsar();
        if (pulsar.getBrokerService().isAuthenticationEnabled() && pulsar.getBrokerService().isAuthorizationEnabled()) {
            return pulsar.getBrokerService().getAuthorizationService().allowBrokerOperationAsync(cluster, brokerId, operation, this.originalPrincipal(), this.clientAppId(), this.clientAuthData()).thenAccept(isAuthorized -> {
                if (!isAuthorized.booleanValue()) {
                    throw new RestException(Response.Status.UNAUTHORIZED, String.format("Unauthorized to validateBrokerOperation for originalPrincipal [%s] and clientAppId [%s] about operation [%s] on broker [%s]", this.originalPrincipal(), this.clientAppId(), operation.toString(), brokerId));
                }
            });
        }
        return CompletableFuture.completedFuture(null);
    }
}

