/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import com.google.common.annotations.VisibleForTesting;
import io.netty.util.concurrent.FastThreadLocal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.commons.collections4.MapUtils;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.ConsistentHashingStickyKeyConsumerSelector;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.EntryAndMetadata;
import org.apache.pulsar.broker.service.EntryBatchIndexesAcks;
import org.apache.pulsar.broker.service.EntryBatchSizes;
import org.apache.pulsar.broker.service.HashRangeAutoSplitStickyKeyConsumerSelector;
import org.apache.pulsar.broker.service.HashRangeExclusiveStickyKeyConsumerSelector;
import org.apache.pulsar.broker.service.SendMessageInfo;
import org.apache.pulsar.broker.service.StickyKeyConsumerSelector;
import org.apache.pulsar.broker.service.StickyKeyDispatcher;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.persistent.PersistentDispatcherMultipleConsumersClassic;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.client.api.Range;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.api.proto.KeySharedMeta;
import org.apache.pulsar.common.api.proto.KeySharedMode;
import org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentStickyKeyDispatcherMultipleConsumersClassic
extends PersistentDispatcherMultipleConsumersClassic
implements StickyKeyDispatcher {
    private final boolean allowOutOfOrderDelivery;
    private final StickyKeyConsumerSelector selector;
    private boolean isDispatcherStuckOnReplays = false;
    private final KeySharedMode keySharedMode;
    private final LinkedHashMap<Consumer, Position> recentlyJoinedConsumers;
    public boolean sortRecentlyJoinedConsumersIfNeeded = true;
    private static final FastThreadLocal<Map<Consumer, List<Entry>>> localGroupedEntries = new FastThreadLocal<Map<Consumer, List<Entry>>>(){

        protected Map<Consumer, List<Entry>> initialValue() throws Exception {
            return new HashMap<Consumer, List<Entry>>();
        }
    };
    private static final FastThreadLocal<Map<Consumer, List<Position>>> localGroupedPositions = new FastThreadLocal<Map<Consumer, List<Position>>>(){

        protected Map<Consumer, List<Position>> initialValue() throws Exception {
            return new HashMap<Consumer, List<Position>>();
        }
    };
    private static final Logger log = LoggerFactory.getLogger(PersistentStickyKeyDispatcherMultipleConsumersClassic.class);

    PersistentStickyKeyDispatcherMultipleConsumersClassic(PersistentTopic topic, ManagedCursor cursor, Subscription subscription, ServiceConfiguration conf, KeySharedMeta ksm) {
        super(topic, cursor, subscription, ksm.isAllowOutOfOrderDelivery());
        this.allowOutOfOrderDelivery = ksm.isAllowOutOfOrderDelivery();
        this.recentlyJoinedConsumers = this.allowOutOfOrderDelivery ? null : new LinkedHashMap();
        this.keySharedMode = ksm.getKeySharedMode();
        switch (this.keySharedMode) {
            case AUTO_SPLIT: {
                if (conf.isSubscriptionKeySharedUseConsistentHashing()) {
                    this.selector = new ConsistentHashingStickyKeyConsumerSelector(conf.getSubscriptionKeySharedConsistentHashingReplicaPoints(), false, 0x7FFFFFFE);
                    break;
                }
                this.selector = new HashRangeAutoSplitStickyKeyConsumerSelector();
                break;
            }
            case STICKY: {
                this.selector = new HashRangeExclusiveStickyKeyConsumerSelector();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid key-shared mode: " + String.valueOf(this.keySharedMode));
            }
        }
    }

    @Override
    @VisibleForTesting
    public StickyKeyConsumerSelector getSelector() {
        return this.selector;
    }

    @Override
    public synchronized CompletableFuture<Void> addConsumer(Consumer consumer) {
        if (IS_CLOSED_UPDATER.get(this) == 1) {
            log.warn("[{}] Dispatcher is already closed. Closing consumer {}", (Object)this.name, (Object)consumer);
            consumer.disconnect();
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)super.addConsumer(consumer).thenCompose(__ -> this.selector.addConsumer(consumer).handle((result, ex) -> {
            if (ex != null) {
                PersistentStickyKeyDispatcherMultipleConsumersClassic persistentStickyKeyDispatcherMultipleConsumersClassic = this;
                synchronized (persistentStickyKeyDispatcherMultipleConsumersClassic) {
                    this.consumerSet.removeAll((Object)consumer);
                    this.consumerList.remove(consumer);
                }
                throw FutureUtil.wrapToCompletionException((Throwable)ex);
            }
            return result;
        }))).thenRun(() -> {
            PersistentStickyKeyDispatcherMultipleConsumersClassic persistentStickyKeyDispatcherMultipleConsumersClassic = this;
            synchronized (persistentStickyKeyDispatcherMultipleConsumersClassic) {
                Position readPositionWhenJoining = this.cursor.getReadPosition();
                consumer.setReadPositionWhenJoining(readPositionWhenJoining);
                if (!this.allowOutOfOrderDelivery && this.recentlyJoinedConsumers != null && this.consumerList.size() > 1 && this.cursor.getNumberOfEntriesSinceFirstNotAckedMessage() > 1L && !this.shouldRewindBeforeReadingOrReplaying) {
                    this.recentlyJoinedConsumers.put(consumer, readPositionWhenJoining);
                    this.sortRecentlyJoinedConsumersIfNeeded();
                }
            }
        });
    }

    private void sortRecentlyJoinedConsumersIfNeeded() {
        if (!this.sortRecentlyJoinedConsumersIfNeeded) {
            return;
        }
        if (this.recentlyJoinedConsumers.size() == 1) {
            return;
        }
        boolean sortNeeded = false;
        Position posPre = null;
        Position posAfter = null;
        for (Map.Entry<Consumer, Position> entry2 : this.recentlyJoinedConsumers.entrySet()) {
            if (posPre == null) {
                posPre = entry2.getValue();
                continue;
            }
            posPre = posAfter;
            posAfter = entry2.getValue();
        }
        if (posPre != null && posAfter != null && posPre.compareTo(posAfter) > 0) {
            sortNeeded = true;
        }
        if (sortNeeded) {
            log.error("[{}] [{}] The items in recentlyJoinedConsumers are out-of-order. {}", new Object[]{this.topic.getName(), this.name, this.recentlyJoinedConsumers.entrySet().stream().map(entry -> String.format("%s-%s:%s", ((Consumer)entry.getKey()).consumerName(), ((Position)entry.getValue()).getLedgerId(), ((Position)entry.getValue()).getEntryId())).collect(Collectors.toList())});
            ArrayList<Map.Entry<Consumer, Position>> sortedList = new ArrayList<Map.Entry<Consumer, Position>>(this.recentlyJoinedConsumers.entrySet());
            Collections.sort(sortedList, Map.Entry.comparingByValue());
            this.recentlyJoinedConsumers.clear();
            for (Map.Entry entry2 : sortedList) {
                this.recentlyJoinedConsumers.put((Consumer)entry2.getKey(), (Position)entry2.getValue());
            }
        }
    }

    @Override
    public synchronized void removeConsumer(Consumer consumer) throws BrokerServiceException {
        this.selector.removeConsumer(consumer);
        super.removeConsumer(consumer);
        if (this.recentlyJoinedConsumers != null) {
            this.recentlyJoinedConsumers.remove(consumer);
            if (this.consumerList.size() == 1) {
                this.recentlyJoinedConsumers.clear();
            }
            if (this.removeConsumersFromRecentJoinedConsumers() || !this.redeliveryMessages.isEmpty()) {
                this.readMoreEntries();
            }
        }
    }

    @Override
    protected synchronized boolean trySendMessagesToConsumers(PersistentDispatcherMultipleConsumersClassic.ReadType readType, List<Entry> entries) {
        NavigableSet<Position> messagesToReplayNow;
        long totalMessagesSent = 0L;
        long totalBytesSent = 0L;
        long totalEntries = 0L;
        int entriesCount = entries.size();
        if (entriesCount == 0) {
            return true;
        }
        if (this.consumerSet.isEmpty()) {
            entries.forEach(Entry::release);
            this.cursor.rewind();
            return false;
        }
        if (!this.allowOutOfOrderDelivery && (messagesToReplayNow = this.getMessagesToReplayNow(1)) != null && !messagesToReplayNow.isEmpty()) {
            Position replayPosition = (Position)messagesToReplayNow.first();
            this.redeliveryMessages.add(replayPosition.getLedgerId(), replayPosition.getEntryId());
            if (this.minReplayedPosition != null && replayPosition.compareTo(this.minReplayedPosition) < 0) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Position {} (<{}) is inserted for relay during current {} read, discard this read and retry with readMoreEntries.", new Object[]{this.name, replayPosition, this.minReplayedPosition, readType});
                }
                if (readType == PersistentDispatcherMultipleConsumersClassic.ReadType.Normal) {
                    entries.forEach(entry -> {
                        long stickyKeyHash = this.getStickyKeyHash((Entry)entry);
                        this.addMessageToReplay(entry.getLedgerId(), entry.getEntryId(), stickyKeyHash);
                        entry.release();
                    });
                } else if (readType == PersistentDispatcherMultipleConsumersClassic.ReadType.Replay) {
                    entries.forEach(Entry::release);
                }
                return true;
            }
        }
        Map groupedEntries = (Map)localGroupedEntries.get();
        groupedEntries.clear();
        HashMap<Consumer, Set> consumerStickyKeyHashesMap = new HashMap<Consumer, Set>();
        for (Entry entry2 : entries) {
            int stickyKeyHash = this.getStickyKeyHash(entry2);
            Consumer c = this.selector.select(stickyKeyHash);
            if (c != null) {
                groupedEntries.computeIfAbsent(c, k -> new ArrayList()).add(entry2);
                consumerStickyKeyHashesMap.computeIfAbsent(c, k -> new HashSet()).add(stickyKeyHash);
                continue;
            }
            this.addMessageToReplay(entry2.getLedgerId(), entry2.getEntryId(), stickyKeyHash);
            entry2.release();
        }
        AtomicInteger keyNumbers = new AtomicInteger(groupedEntries.size());
        int currentThreadKeyNumber = groupedEntries.size();
        if (currentThreadKeyNumber == 0) {
            currentThreadKeyNumber = -1;
        }
        for (Map.Entry current : groupedEntries.entrySet()) {
            Entry entry3;
            int i;
            Consumer consumer = (Consumer)current.getKey();
            assert (consumer != null);
            List entriesWithSameKey = (List)current.getValue();
            int entriesWithSameKeyCount = entriesWithSameKey.size();
            int availablePermits = this.getAvailablePermits(consumer);
            int messagesForC = this.getRestrictedMaxEntriesForConsumer(consumer, entriesWithSameKey.stream().map(Entry::getPosition).collect(Collectors.toList()), availablePermits, readType, (Set)consumerStickyKeyHashesMap.get(consumer));
            if (log.isDebugEnabled()) {
                log.debug("[{}] select consumer {} with messages num {}, read type is {}", new Object[]{this.name, consumer.consumerName(), messagesForC, readType});
            }
            if (messagesForC < entriesWithSameKeyCount) {
                for (i = messagesForC; i < entriesWithSameKeyCount; ++i) {
                    entry3 = (Entry)entriesWithSameKey.get(i);
                    long stickyKeyHash = this.getStickyKeyHash(entry3);
                    this.addMessageToReplay(entry3.getLedgerId(), entry3.getEntryId(), stickyKeyHash);
                    entry3.release();
                    entriesWithSameKey.set(i, null);
                }
            }
            if (messagesForC > 0) {
                if (readType == PersistentDispatcherMultipleConsumersClassic.ReadType.Replay) {
                    for (i = 0; i < messagesForC; ++i) {
                        entry3 = (Entry)entriesWithSameKey.get(i);
                        this.redeliveryMessages.remove(entry3.getLedgerId(), entry3.getEntryId());
                    }
                }
                SendMessageInfo sendMessageInfo = SendMessageInfo.getThreadLocal();
                EntryBatchSizes batchSizes = EntryBatchSizes.get(messagesForC);
                EntryBatchIndexesAcks batchIndexesAcks = EntryBatchIndexesAcks.get(messagesForC);
                totalEntries += (long)this.filterEntriesForConsumer(entriesWithSameKey, batchSizes, sendMessageInfo, batchIndexesAcks, this.cursor, readType == PersistentDispatcherMultipleConsumersClassic.ReadType.Replay, consumer);
                consumer.sendMessages(entriesWithSameKey, batchSizes, batchIndexesAcks, sendMessageInfo.getTotalMessages(), sendMessageInfo.getTotalBytes(), sendMessageInfo.getTotalChunkedMessages(), this.getRedeliveryTracker()).addListener(future -> {
                    if (future.isDone() && keyNumbers.decrementAndGet() == 0) {
                        this.readMoreEntries();
                    }
                });
                TOTAL_AVAILABLE_PERMITS_UPDATER.getAndAdd(this, -(sendMessageInfo.getTotalMessages() - batchIndexesAcks.getTotalAckedIndexCount()));
                totalMessagesSent += (long)sendMessageInfo.getTotalMessages();
                totalBytesSent += sendMessageInfo.getTotalBytes();
                continue;
            }
            currentThreadKeyNumber = keyNumbers.decrementAndGet();
        }
        this.acquirePermitsForDeliveredMessages(this.topic, this.cursor, totalEntries, totalMessagesSent, totalBytesSent);
        if (totalMessagesSent == 0L && (this.recentlyJoinedConsumers == null || this.recentlyJoinedConsumers.isEmpty())) {
            this.isDispatcherStuckOnReplays = true;
            return true;
        }
        return currentThreadKeyNumber == 0;
    }

    private int getRestrictedMaxEntriesForConsumer(Consumer consumer, List<? extends Position> entries, int availablePermits, PersistentDispatcherMultipleConsumersClassic.ReadType readType, Set<Integer> stickyKeyHashes) {
        Position minReadPositionForRecentJoinedConsumer;
        int maxMessages = Math.min(entries.size(), availablePermits);
        if (maxMessages == 0) {
            return 0;
        }
        if (readType == PersistentDispatcherMultipleConsumersClassic.ReadType.Normal && stickyKeyHashes != null && this.redeliveryMessages.containsStickyKeyHashes(stickyKeyHashes)) {
            return 0;
        }
        if (this.recentlyJoinedConsumers == null) {
            return maxMessages;
        }
        this.removeConsumersFromRecentJoinedConsumers();
        Position maxReadPosition = this.recentlyJoinedConsumers.get(consumer);
        if (maxReadPosition == null) {
            return maxMessages;
        }
        if (readType == PersistentDispatcherMultipleConsumersClassic.ReadType.Replay && (minReadPositionForRecentJoinedConsumer = this.recentlyJoinedConsumers.values().iterator().next()) != null && minReadPositionForRecentJoinedConsumer.compareTo(maxReadPosition) < 0) {
            maxReadPosition = minReadPositionForRecentJoinedConsumer;
        }
        for (int i = 0; i < maxMessages; ++i) {
            if (entries.get(i).compareTo(maxReadPosition) < 0) continue;
            return i;
        }
        return maxMessages;
    }

    @Override
    public void markDeletePositionMoveForward() {
        this.topic.getBrokerService().getTopicOrderedExecutor().execute(() -> {
            PersistentStickyKeyDispatcherMultipleConsumersClassic persistentStickyKeyDispatcherMultipleConsumersClassic = this;
            synchronized (persistentStickyKeyDispatcherMultipleConsumersClassic) {
                if (this.recentlyJoinedConsumers != null && !this.recentlyJoinedConsumers.isEmpty() && this.removeConsumersFromRecentJoinedConsumers()) {
                    this.readMoreEntries();
                }
            }
        });
    }

    private boolean removeConsumersFromRecentJoinedConsumers() {
        if (MapUtils.isEmpty(this.recentlyJoinedConsumers)) {
            return false;
        }
        Iterator<Map.Entry<Consumer, Position>> itr = this.recentlyJoinedConsumers.entrySet().iterator();
        boolean hasConsumerRemovedFromTheRecentJoinedConsumers = false;
        Position mdp = this.cursor.getMarkDeletedPosition();
        if (mdp != null) {
            Map.Entry<Consumer, Position> entry;
            Position nextPositionOfTheMarkDeletePosition = ((ManagedLedgerImpl)this.cursor.getManagedLedger()).getNextValidPosition(mdp);
            while (itr.hasNext() && (entry = itr.next()).getValue().compareTo(nextPositionOfTheMarkDeletePosition) <= 0) {
                itr.remove();
                hasConsumerRemovedFromTheRecentJoinedConsumers = true;
            }
        }
        return hasConsumerRemovedFromTheRecentJoinedConsumers;
    }

    @Override
    protected synchronized NavigableSet<Position> getMessagesToReplayNow(int maxMessagesToRead) {
        if (this.isDispatcherStuckOnReplays) {
            this.isDispatcherStuckOnReplays = false;
            return Collections.emptyNavigableSet();
        }
        return super.getMessagesToReplayNow(maxMessagesToRead);
    }

    private int getAvailablePermits(Consumer c) {
        int availablePermits = Math.max(c.getAvailablePermits(), 0);
        if (c.getMaxUnackedMessages() > 0) {
            int remainUnAckedMessages = Math.max(c.getMaxUnackedMessages() - c.getUnackedMessages(), 0);
            availablePermits = Math.min(availablePermits, remainUnAckedMessages);
        }
        return availablePermits;
    }

    @Override
    protected synchronized NavigableSet<Position> filterOutEntriesWillBeDiscarded(NavigableSet<Position> src) {
        if (this.isAllowOutOfOrderDelivery()) {
            return src;
        }
        if (src.isEmpty()) {
            return src;
        }
        TreeSet<Position> res = new TreeSet<Position>();
        Map groupedPositions = (Map)localGroupedPositions.get();
        groupedPositions.clear();
        for (Position position : src) {
            Long stickyKeyHash = this.redeliveryMessages.getHash(position.getLedgerId(), position.getEntryId());
            if (stickyKeyHash == null) {
                res.add(position);
                continue;
            }
            Consumer c = this.selector.select(stickyKeyHash.intValue());
            if (c == null) continue;
            groupedPositions.computeIfAbsent(c, k -> new ArrayList()).add(position);
        }
        for (Map.Entry entry : groupedPositions.entrySet()) {
            int posCountToRead;
            int availablePermits = this.getAvailablePermits((Consumer)entry.getKey());
            if (availablePermits == 0 || (posCountToRead = this.getRestrictedMaxEntriesForConsumer((Consumer)entry.getKey(), (List)entry.getValue(), availablePermits, PersistentDispatcherMultipleConsumersClassic.ReadType.Replay, null)) <= 0) continue;
            res.addAll(((List)entry.getValue()).subList(0, posCountToRead));
        }
        return res;
    }

    @Override
    protected boolean hasConsumersNeededNormalRead() {
        if (this.isAllowOutOfOrderDelivery()) {
            return true;
        }
        for (Consumer consumer : this.consumerList) {
            if (consumer == null || consumer.isBlocked() || this.recentlyJoinedConsumers.containsKey(consumer) || consumer.getAvailablePermits() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public CommandSubscribe.SubType getType() {
        return CommandSubscribe.SubType.Key_Shared;
    }

    @Override
    protected Set<? extends Position> asyncReplayEntries(Set<? extends Position> positions) {
        return this.cursor.asyncReplayEntries(positions, (AsyncCallbacks.ReadEntriesCallback)this, (Object)PersistentDispatcherMultipleConsumersClassic.ReadType.Replay, true);
    }

    @Override
    public KeySharedMode getKeySharedMode() {
        return this.keySharedMode;
    }

    @Override
    public boolean isAllowOutOfOrderDelivery() {
        return this.allowOutOfOrderDelivery;
    }

    @Override
    public boolean hasSameKeySharedPolicy(KeySharedMeta ksm) {
        return ksm.getKeySharedMode() == this.keySharedMode && ksm.isAllowOutOfOrderDelivery() == this.allowOutOfOrderDelivery;
    }

    @Override
    public synchronized LinkedHashMap<Consumer, Position> getRecentlyJoinedConsumers() {
        if (this.recentlyJoinedConsumers == null) {
            return null;
        }
        return new LinkedHashMap<Consumer, Position>(this.recentlyJoinedConsumers);
    }

    @Override
    public Map<Consumer, List<Range>> getConsumerKeyHashRanges() {
        return this.selector.getConsumerKeyHashRanges();
    }

    @Override
    protected int getStickyKeyHash(Entry entry) {
        if (entry instanceof EntryAndMetadata) {
            EntryAndMetadata entryAndMetadata = (EntryAndMetadata)entry;
            return entryAndMetadata.getOrUpdateCachedStickyKeyHash(this.selector::makeStickyKeyHash);
        }
        return this.selector.makeStickyKeyHash(this.peekStickyKey(entry.getDataBuffer()));
    }

    @Generated
    public void setSortRecentlyJoinedConsumersIfNeeded(boolean sortRecentlyJoinedConsumersIfNeeded) {
        this.sortRecentlyJoinedConsumersIfNeeded = sortRecentlyJoinedConsumersIfNeeded;
    }
}

