/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.pulsar.broker.service.schema.AvroSchemaBasedCompatibilityCheck;
import org.apache.pulsar.broker.service.schema.exceptions.IncompatibleSchemaException;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.common.util.ObjectMapperFactory;

public class JsonSchemaCompatibilityCheck
extends AvroSchemaBasedCompatibilityCheck {
    private static final ObjectReader JSON_SCHEMA_READER = ObjectMapperFactory.getMapper().reader().forType(JsonSchema.class);

    @Override
    public SchemaType getSchemaType() {
        return SchemaType.JSON;
    }

    @Override
    public void checkCompatible(SchemaData from, SchemaData to, SchemaCompatibilityStrategy strategy) throws IncompatibleSchemaException {
        if (this.isAvroSchema(from)) {
            if (this.isAvroSchema(to)) {
                super.checkCompatible(from, to, strategy);
            } else if (!this.isJsonSchema(to)) {
                throw new IncompatibleSchemaException("Unknown schema format");
            }
        } else if (this.isJsonSchema(from) && !this.isAvroSchema(to)) {
            if (this.isJsonSchema(to)) {
                this.isCompatibleJsonSchema(from, to);
            } else {
                throw new IncompatibleSchemaException("Unknown schema format");
            }
        }
    }

    private void isCompatibleJsonSchema(SchemaData from, SchemaData to) throws IncompatibleSchemaException {
        try {
            JsonSchema fromSchema = (JsonSchema)JSON_SCHEMA_READER.readValue(from.getData());
            JsonSchema toSchema = (JsonSchema)JSON_SCHEMA_READER.readValue(to.getData());
            if (!fromSchema.getId().equals(toSchema.getId())) {
                throw new IncompatibleSchemaException(String.format("Incompatible Schema from %s + to %s", new String(from.getData(), StandardCharsets.UTF_8), new String(to.getData(), StandardCharsets.UTF_8)));
            }
        }
        catch (IOException e) {
            throw new IncompatibleSchemaException(e);
        }
    }

    private boolean isAvroSchema(SchemaData schemaData) {
        try {
            Schema.Parser fromParser = new Schema.Parser();
            fromParser.setValidateDefaults(false);
            Schema fromSchema = fromParser.parse(new String(schemaData.getData(), StandardCharsets.UTF_8));
            return true;
        }
        catch (SchemaParseException e) {
            return false;
        }
    }

    private boolean isJsonSchema(SchemaData schemaData) {
        try {
            JsonSchema fromSchema = (JsonSchema)JSON_SCHEMA_READER.readValue(schemaData.getData());
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

