/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl;

import org.apache.pulsar.jetcd.shaded.io.vertx.core.Future;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Handler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Promise;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.buffer.Buffer;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.ContextInternal;

class HttpEventHandler {
    final ContextInternal context;
    private Handler<Buffer> chunkHandler;
    private Handler<Void> endHandler;
    private Handler<Throwable> exceptionHandler;
    private Buffer body;
    private Promise<Buffer> bodyPromise;
    private Promise<Void> endPromise;

    HttpEventHandler(ContextInternal context) {
        this.context = context;
    }

    void chunkHandler(Handler<Buffer> handler) {
        this.chunkHandler = handler;
    }

    void endHandler(Handler<Void> handler) {
        this.endHandler = handler;
    }

    void exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
    }

    void handleChunk(Buffer chunk) {
        Handler<Buffer> handler = this.chunkHandler;
        if (handler != null) {
            this.context.dispatch(chunk, handler);
        }
        if (this.body != null) {
            this.body.appendBuffer(chunk);
        }
    }

    Future<Buffer> body() {
        if (this.body == null) {
            this.body = Buffer.buffer();
            this.bodyPromise = this.context.promise();
        }
        return this.bodyPromise.future();
    }

    Future<Void> end() {
        if (this.endPromise == null) {
            this.endPromise = this.context.promise();
        }
        return this.endPromise.future();
    }

    void handleEnd() {
        Handler<Void> handler = this.endHandler;
        if (handler != null) {
            this.context.dispatch(handler);
        }
        if (this.bodyPromise != null) {
            this.bodyPromise.tryComplete(this.body);
        }
        if (this.endPromise != null) {
            this.endPromise.tryComplete();
        }
    }

    void handleException(Throwable err) {
        Handler<Throwable> handler = this.exceptionHandler;
        if (handler != null) {
            this.context.dispatch(err, handler);
        }
        if (this.bodyPromise != null) {
            this.bodyPromise.tryFail(err);
        }
        if (this.endPromise != null) {
            this.endPromise.tryFail(err);
        }
    }
}

