/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.config;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.common.config.ConcurrentBaseConfiguration;
import org.apache.distributedlog.common.config.ConcurrentConstConfiguration;
import org.apache.distributedlog.common.config.ConfigurationSubscription;
import org.apache.distributedlog.config.DynamicDistributedLogConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicConfigurationFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicConfigurationFactory.class);
    private final Map<String, DynamicDistributedLogConfiguration> dynamicConfigs;
    private final List<ConfigurationSubscription> subscriptions;
    private final ScheduledExecutorService executorService;
    private final int reloadPeriod;
    private final TimeUnit reloadUnit;

    public DynamicConfigurationFactory(ScheduledExecutorService executorService, int reloadPeriod, TimeUnit reloadUnit) {
        this.executorService = executorService;
        this.reloadPeriod = reloadPeriod;
        this.reloadUnit = reloadUnit;
        this.dynamicConfigs = new HashMap<String, DynamicDistributedLogConfiguration>();
        this.subscriptions = new LinkedList<ConfigurationSubscription>();
    }

    public synchronized Optional<DynamicDistributedLogConfiguration> getDynamicConfiguration(String configPath, ConcurrentBaseConfiguration defaultConf) throws ConfigurationException {
        Preconditions.checkNotNull((Object)configPath);
        if (!this.dynamicConfigs.containsKey(configPath)) {
            File configFile = new File(configPath);
            DynamicDistributedLogConfiguration dynConf = new DynamicDistributedLogConfiguration(defaultConf);
            ConfigurationSubscription subscription = new ConfigurationSubscription((ConcurrentBaseConfiguration)dynConf, Collections.singletonList(configFile), this.executorService, this.reloadPeriod, this.reloadUnit);
            this.subscriptions.add(subscription);
            this.dynamicConfigs.put(configPath, dynConf);
            LOG.info("Loaded dynamic configuration at {}", (Object)configPath);
        }
        return Optional.of(this.dynamicConfigs.get(configPath));
    }

    public synchronized Optional<DynamicDistributedLogConfiguration> getDynamicConfiguration(String configPath) throws ConfigurationException {
        return this.getDynamicConfiguration(configPath, (ConcurrentBaseConfiguration)new ConcurrentConstConfiguration((Configuration)new DistributedLogConfiguration()));
    }
}

