/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.net;

import java.util.ArrayList;
import java.util.List;
import org.apache.distributedlog.net.DNSResolverForRacks;
import org.apache.distributedlog.net.DNSResolverForRows;
import org.junit.Assert;
import org.junit.Test;

public class TestDNSResolver {
    private static final String host1 = "r1-w1rack1-1111-2222.distributedlog.io";
    private static final String host2 = "r2-w2rack2-3333-4444.distributedlog.io";

    @Test(timeout=20000L)
    public void testDNSResolverForRacks() {
        DNSResolverForRacks dnsResolver = new DNSResolverForRacks("");
        ArrayList<String> ipList = new ArrayList<String>();
        ipList.add("192.0.0.1");
        List racks = dnsResolver.resolve(ipList);
        Assert.assertEquals((Object)"/default-region/default-rack", racks.get(0));
        ArrayList<String> unknownList = new ArrayList<String>();
        unknownList.add("unknown");
        racks = dnsResolver.resolve(unknownList);
        Assert.assertEquals((Object)"/default-region/default-rack", racks.get(0));
        ArrayList<String> r1List = new ArrayList<String>();
        r1List.add(host1);
        racks = dnsResolver.resolve(r1List);
        Assert.assertEquals((Object)"/r1/w1rack1", racks.get(0));
        ArrayList<String> r2List = new ArrayList<String>();
        r2List.add(host2);
        racks = dnsResolver.resolve(r2List);
        Assert.assertEquals((Object)"/r2/w2rack2", racks.get(0));
    }

    @Test(timeout=20000L)
    public void testDNSResolverForRows() {
        DNSResolverForRows dnsResolver = new DNSResolverForRows("");
        ArrayList<String> ipList = new ArrayList<String>();
        ipList.add("192.0.0.1");
        List rows = dnsResolver.resolve(ipList);
        Assert.assertEquals((Object)"/default-region/default-row", rows.get(0));
        ArrayList<String> unknownList = new ArrayList<String>();
        unknownList.add("unknown");
        rows = dnsResolver.resolve(unknownList);
        Assert.assertEquals((Object)"/default-region/default-row", rows.get(0));
        ArrayList<String> r1List = new ArrayList<String>();
        r1List.add(host1);
        rows = dnsResolver.resolve(r1List);
        Assert.assertEquals((Object)"/r1/w1", rows.get(0));
        ArrayList<String> r2List = new ArrayList<String>();
        r2List.add(host2);
        rows = dnsResolver.resolve(r2List);
        Assert.assertEquals((Object)"/r2/w2", rows.get(0));
    }

    @Test(timeout=20000L)
    public void testDNSResolverOverrides() {
        DNSResolverForRacks dnsResolver = new DNSResolverForRacks("r1-w1rack1-1111-2222:r3;r2-w2rack2-3333-4444:r3");
        ArrayList<String> r1List = new ArrayList<String>();
        r1List.add(host1);
        List racks = dnsResolver.resolve(r1List);
        Assert.assertEquals((Object)"/r3/w1rack1", racks.get(0));
        ArrayList<String> r2List = new ArrayList<String>();
        r2List.add(host2);
        racks = dnsResolver.resolve(r2List);
        Assert.assertEquals((Object)"/r3/w2rack2", racks.get(0));
    }
}

