# Background knowledge
A consumer is a process that attaches to a topic via a subscription and then receives messages. The reader interface for Pulsar enables applications to manually manage cursors. More knowledge of the Reader and Consumer interface can be found in the [Pulsar Client doc](https://pulsar.apache.org/docs/next/concepts-clients/#reader).

# Motivation

Add the `getLastMessageIds` API for Reader.  This will help to increase the flexibility of reader usage.

# Goals

## In Scope

Add the `getLastMessageIds` API for Reader.

## Out of Scope

None.


# High Level Design

Implement the `getLastMessageIds` method for Reader by internally invoking the Consumer interface.

# Detailed Design

## Design & Implementation Details
```java
    @Override
    public List<TopicMessageId> getLastMessageIds() throws PulsarClientException {
        return consumer.getLastMessageIds();
    }

    @Override
    public CompletableFuture<List<TopicMessageId>> getLastMessageIdsAsync() {
        return consumer.getLastMessageIdsAsync();
    }
```

## Public-facing Changes



### Public API
```java
    /**
     * Get all the last message id of the topics the reader subscribed.
     *
     * @return the list of TopicMessageId instances of all the topics that the reader subscribed
     * @throws PulsarClientException if failed to get last message id.
     * @apiNote It's guaranteed that the owner topic of each TopicMessageId in the returned list is different from owner
     *   topics of other TopicMessageId instances
     */
    List<TopicMessageId> getLastMessageIds() throws PulsarClientException;

    /**
     * The asynchronous version of {@link Reader#getLastMessageIds()}.
     */
    CompletableFuture<List<TopicMessageId>> getLastMessageIdsAsync();
```
### Binary protocol

### Configuration

### CLI

### Metrics

# Monitoring


# Security Considerations


# Backward & Forward Compatibility

## Revert


## Upgrade



# Alternatives


# General Notes

# Links

<!--
Updated afterwards
-->
* Mailing List discussion thread:
* Mailing List voting thread:
