/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookieWatcher;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.LedgerFragment;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookieClient;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerChecker {
    private static final Logger LOG = LoggerFactory.getLogger(LedgerChecker.class);
    public final BookieClient bookieClient;
    public final BookieWatcher bookieWatcher;
    final Semaphore semaphore;

    public LedgerChecker(BookKeeper bkc) {
        this(bkc.getBookieClient(), bkc.getBookieWatcher());
    }

    public LedgerChecker(BookieClient client, BookieWatcher watcher) {
        this(client, watcher, -1);
    }

    public LedgerChecker(BookKeeper bkc, int inFlightReadEntryNum) {
        this(bkc.getBookieClient(), bkc.getBookieWatcher(), inFlightReadEntryNum);
    }

    public LedgerChecker(BookieClient client, BookieWatcher watcher, int inFlightReadEntryNum) {
        this.bookieClient = client;
        this.bookieWatcher = watcher;
        this.semaphore = inFlightReadEntryNum > 0 ? new Semaphore(inFlightReadEntryNum) : null;
    }

    public void acquirePermit() throws InterruptedException {
        if (null != this.semaphore) {
            this.semaphore.acquire(1);
        }
    }

    public void releasePermit() {
        if (null != this.semaphore) {
            this.semaphore.release();
        }
    }

    private void verifyLedgerFragment(LedgerFragment fragment, BookkeeperInternalCallbacks.GenericCallback<LedgerFragment> cb, Long percentageOfLedgerFragmentToBeVerified) throws InvalidFragmentException, BKException, InterruptedException {
        Set<Integer> bookiesToCheck = fragment.getBookiesIndexes();
        if (bookiesToCheck.isEmpty()) {
            cb.operationComplete(0, fragment);
            return;
        }
        AtomicInteger numBookies = new AtomicInteger(bookiesToCheck.size());
        HashMap<Integer, Integer> badBookies = new HashMap<Integer, Integer>();
        for (Integer bookieIndex : bookiesToCheck) {
            LedgerFragmentCallback lfCb = new LedgerFragmentCallback(fragment, bookieIndex, cb, badBookies, numBookies);
            this.verifyLedgerFragment(fragment, bookieIndex, lfCb, percentageOfLedgerFragmentToBeVerified);
        }
    }

    private void verifyLedgerFragment(LedgerFragment fragment, int bookieIndex, BookkeeperInternalCallbacks.GenericCallback<LedgerFragment> cb, long percentageOfLedgerFragmentToBeVerified) throws InvalidFragmentException, InterruptedException {
        long firstStored;
        long lastStored = fragment.getLastStoredEntryId(bookieIndex);
        BookieId bookie = fragment.getAddress(bookieIndex);
        if (null == bookie) {
            throw new InvalidFragmentException();
        }
        if (firstStored == -1L) {
            if (lastStored != -1L) {
                throw new InvalidFragmentException();
            }
            if (this.bookieWatcher.isBookieUnavailable(fragment.getAddress(bookieIndex))) {
                cb.operationComplete(-8, fragment);
            } else {
                cb.operationComplete(0, fragment);
            }
        } else if (this.bookieWatcher.isBookieUnavailable(fragment.getAddress(bookieIndex))) {
            cb.operationComplete(-8, fragment);
        } else if (firstStored == lastStored) {
            this.acquirePermit();
            ReadManyEntriesCallback manycb = new ReadManyEntriesCallback(1L, fragment, cb);
            this.bookieClient.readEntry(bookie, fragment.getLedgerId(), firstStored, manycb, bookie, 0);
        } else {
            if (lastStored <= firstStored) {
                cb.operationComplete(-14, null);
                return;
            }
            long lengthOfLedgerFragment = lastStored - firstStored + 1L;
            int numberOfEntriesToBeVerified = (int)((double)lengthOfLedgerFragment * ((double)percentageOfLedgerFragmentToBeVerified / 100.0));
            TreeSet<Long> entriesToBeVerified = new TreeSet<Long>();
            if ((long)numberOfEntriesToBeVerified < lengthOfLedgerFragment) {
                if (numberOfEntriesToBeVerified > 0) {
                    int lengthOfBucket = (int)(lengthOfLedgerFragment / (long)numberOfEntriesToBeVerified);
                    for (long index = firstStored; index < lastStored - (long)lengthOfBucket - 1L; index += (long)lengthOfBucket) {
                        long potentialEntryId = (long)ThreadLocalRandom.current().nextInt(lengthOfBucket) + index;
                        if (!fragment.isStoredEntryId(potentialEntryId, bookieIndex)) continue;
                        entriesToBeVerified.add(potentialEntryId);
                    }
                }
                entriesToBeVerified.add(firstStored);
                entriesToBeVerified.add(lastStored);
            } else {
                for (firstStored = fragment.getFirstStoredEntryId(bookieIndex).longValue(); firstStored <= lastStored; ++firstStored) {
                    if (!fragment.isStoredEntryId(firstStored, bookieIndex)) continue;
                    entriesToBeVerified.add(firstStored);
                }
            }
            ReadManyEntriesCallback manycb = new ReadManyEntriesCallback(entriesToBeVerified.size(), fragment, cb);
            for (Long entryID : entriesToBeVerified) {
                this.acquirePermit();
                this.bookieClient.readEntry(bookie, fragment.getLedgerId(), entryID, manycb, bookie, 0);
            }
        }
    }

    public void checkLedger(LedgerHandle lh, BookkeeperInternalCallbacks.GenericCallback<Set<LedgerFragment>> cb) {
        this.checkLedger(lh, cb, 0L);
    }

    public void checkLedger(LedgerHandle lh, BookkeeperInternalCallbacks.GenericCallback<Set<LedgerFragment>> cb, long percentageOfLedgerFragmentToBeVerified) {
        int i;
        HashSet<Integer> bookieIndexes;
        final LinkedHashSet<LedgerFragment> fragments = new LinkedHashSet<LedgerFragment>();
        Long curEntryId = null;
        List curEnsemble = null;
        for (Map.Entry e : lh.getLedgerMetadata().getAllEnsembles().entrySet()) {
            if (curEntryId != null) {
                bookieIndexes = new HashSet<Integer>();
                for (i = 0; i < curEnsemble.size(); ++i) {
                    bookieIndexes.add(i);
                }
                fragments.add(new LedgerFragment(lh, curEntryId, (Long)e.getKey() - 1L, bookieIndexes));
            }
            curEntryId = (Long)e.getKey();
            curEnsemble = (List)e.getValue();
        }
        if (curEntryId != null) {
            long lastEntry = lh.getLastAddConfirmed();
            if (!lh.isClosed() && lastEntry < curEntryId) {
                lastEntry = curEntryId;
            }
            bookieIndexes = new HashSet();
            for (i = 0; i < curEnsemble.size(); ++i) {
                bookieIndexes.add(i);
            }
            final LedgerFragment lastLedgerFragment = new LedgerFragment(lh, curEntryId, lastEntry, bookieIndexes);
            if (curEntryId == lastEntry) {
                long entryToRead = curEntryId;
                final CompletableFuture future = new CompletableFuture();
                future.whenCompleteAsync((re, ex) -> this.checkFragments(fragments, cb, percentageOfLedgerFragmentToBeVerified));
                EntryExistsCallback eecb = new EntryExistsCallback(lh.getLedgerMetadata().getWriteQuorumSize(), new BookkeeperInternalCallbacks.GenericCallback<Boolean>(){

                    @Override
                    public void operationComplete(int rc, Boolean result) {
                        if (result.booleanValue()) {
                            fragments.add(lastLedgerFragment);
                        }
                        future.complete(null);
                    }
                });
                DistributionSchedule ds = lh.getDistributionSchedule();
                for (int i2 = 0; i2 < ds.getWriteQuorumSize(); ++i2) {
                    try {
                        this.acquirePermit();
                        BookieId addr = (BookieId)curEnsemble.get(ds.getWriteSetBookieIndex(entryToRead, i2));
                        this.bookieClient.readEntry(addr, lh.getId(), entryToRead, eecb, null, 0);
                        continue;
                    }
                    catch (InterruptedException e) {
                        LOG.error("InterruptedException when checking entry : {}", (Object)entryToRead, (Object)e);
                    }
                }
                return;
            }
            fragments.add(lastLedgerFragment);
        }
        this.checkFragments(fragments, cb, percentageOfLedgerFragmentToBeVerified);
    }

    private void checkFragments(Set<LedgerFragment> fragments, BookkeeperInternalCallbacks.GenericCallback<Set<LedgerFragment>> cb, long percentageOfLedgerFragmentToBeVerified) {
        if (fragments.size() == 0) {
            cb.operationComplete(0, fragments);
            return;
        }
        FullLedgerCallback allFragmentsCb = new FullLedgerCallback(fragments.size(), cb);
        for (LedgerFragment r : fragments) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking fragment {}", (Object)r);
            }
            try {
                this.verifyLedgerFragment(r, allFragmentsCb, percentageOfLedgerFragmentToBeVerified);
            }
            catch (InvalidFragmentException ife) {
                LOG.error("Invalid fragment found : {}", (Object)r);
                allFragmentsCb.operationComplete(-14, r);
            }
            catch (BKException e) {
                LOG.error("BKException when checking fragment : {}", (Object)r, (Object)e);
            }
            catch (InterruptedException e) {
                LOG.error("InterruptedException when checking fragment : {}", (Object)r, (Object)e);
            }
        }
    }

    private static class FullLedgerCallback
    implements BookkeeperInternalCallbacks.GenericCallback<LedgerFragment> {
        final Set<LedgerFragment> badFragments = new LinkedHashSet<LedgerFragment>();
        final AtomicLong numFragments;
        final BookkeeperInternalCallbacks.GenericCallback<Set<LedgerFragment>> cb;

        FullLedgerCallback(long numFragments, BookkeeperInternalCallbacks.GenericCallback<Set<LedgerFragment>> cb) {
            this.numFragments = new AtomicLong(numFragments);
            this.cb = cb;
        }

        @Override
        public void operationComplete(int rc, LedgerFragment result) {
            if (rc == -19) {
                this.cb.operationComplete(-19, this.badFragments);
                return;
            }
            if (rc != 0) {
                this.badFragments.add(result);
            }
            if (this.numFragments.decrementAndGet() == 0L) {
                this.cb.operationComplete(0, this.badFragments);
            }
        }
    }

    private class EntryExistsCallback
    implements BookkeeperInternalCallbacks.ReadEntryCallback {
        AtomicBoolean entryMayExist = new AtomicBoolean(false);
        final AtomicInteger numReads;
        final BookkeeperInternalCallbacks.GenericCallback<Boolean> cb;

        EntryExistsCallback(int numReads, BookkeeperInternalCallbacks.GenericCallback<Boolean> cb) {
            this.numReads = new AtomicInteger(numReads);
            this.cb = cb;
        }

        @Override
        public void readEntryComplete(int rc, long ledgerId, long entryId, ByteBuf buffer, Object ctx) {
            LedgerChecker.this.releasePermit();
            if (-13 != rc && -7 != rc && -25 != rc) {
                this.entryMayExist.set(true);
            }
            if (this.numReads.decrementAndGet() == 0) {
                this.cb.operationComplete(rc, this.entryMayExist.get());
            }
        }
    }

    private static class LedgerFragmentCallback
    implements BookkeeperInternalCallbacks.GenericCallback<LedgerFragment> {
        private final LedgerFragment fragment;
        private final int bookieIndex;
        private final Map<Integer, Integer> badBookies;
        private final AtomicInteger numBookies;
        private final BookkeeperInternalCallbacks.GenericCallback<LedgerFragment> cb;

        LedgerFragmentCallback(LedgerFragment lf, int bookieIndex, BookkeeperInternalCallbacks.GenericCallback<LedgerFragment> cb, Map<Integer, Integer> badBookies, AtomicInteger numBookies) {
            this.fragment = lf;
            this.bookieIndex = bookieIndex;
            this.cb = cb;
            this.badBookies = badBookies;
            this.numBookies = numBookies;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void operationComplete(int rc, LedgerFragment lf) {
            if (0 != rc) {
                Map<Integer, Integer> map = this.badBookies;
                synchronized (map) {
                    this.badBookies.put(this.bookieIndex, rc);
                }
            }
            if (this.numBookies.decrementAndGet() == 0) {
                if (this.badBookies.isEmpty()) {
                    this.cb.operationComplete(0, this.fragment);
                } else {
                    int rcToReturn = -3;
                    for (Map.Entry<Integer, Integer> entry : this.badBookies.entrySet()) {
                        rcToReturn = entry.getValue();
                        if (entry.getValue() != -19) continue;
                        break;
                    }
                    this.cb.operationComplete(rcToReturn, this.fragment.subset(this.badBookies.keySet()));
                }
            }
        }
    }

    private class ReadManyEntriesCallback
    implements BookkeeperInternalCallbacks.ReadEntryCallback {
        AtomicBoolean completed = new AtomicBoolean(false);
        final AtomicLong numEntries;
        final LedgerFragment fragment;
        final BookkeeperInternalCallbacks.GenericCallback<LedgerFragment> cb;

        ReadManyEntriesCallback(long numEntries, LedgerFragment fragment, BookkeeperInternalCallbacks.GenericCallback<LedgerFragment> cb) {
            this.numEntries = new AtomicLong(numEntries);
            this.fragment = fragment;
            this.cb = cb;
        }

        @Override
        public void readEntryComplete(int rc, long ledgerId, long entryId, ByteBuf buffer, Object ctx) {
            LedgerChecker.this.releasePermit();
            if (rc == 0) {
                if (this.numEntries.decrementAndGet() == 0L && !this.completed.getAndSet(true)) {
                    this.cb.operationComplete(rc, this.fragment);
                }
            } else if (!this.completed.getAndSet(true)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Read {}:{} from {} failed, the error code: {}", new Object[]{ledgerId, entryId, ctx, rc});
                }
                this.cb.operationComplete(rc, this.fragment);
            }
        }
    }

    static class InvalidFragmentException
    extends Exception {
        private static final long serialVersionUID = 1467201276417062353L;

        InvalidFragmentException() {
        }
    }
}

