/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.testclient.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;

public class PaddingDecimalFormat
extends DecimalFormat {
    private int minimumLength;

    public PaddingDecimalFormat(String pattern, int minLength) {
        super(pattern);
        this.minimumLength = minLength;
    }

    public PaddingDecimalFormat(String pattern, DecimalFormatSymbols symbols, int minLength) {
        super(pattern, symbols);
        this.minimumLength = minLength;
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        int initLength = toAppendTo.length();
        super.format(number, toAppendTo, pos);
        return this.pad(toAppendTo, initLength);
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        int initLength = toAppendTo.length();
        super.format(number, toAppendTo, pos);
        return this.pad(toAppendTo, initLength);
    }

    private StringBuffer pad(StringBuffer toAppendTo, int initLength) {
        int numLength = toAppendTo.length() - initLength;
        int padLength = this.minimumLength - numLength;
        if (padLength > 0) {
            StringBuilder pad = new StringBuilder(padLength);
            for (int i = 0; i < padLength; ++i) {
                pad.append(' ');
            }
            toAppendTo.insert(initLength, pad);
        }
        return toAppendTo;
    }
}

