/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.topiclistlimit;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pulsar.common.api.proto.CommandGetTopicsOfNamespace;

public class TopicListSizeResultCache {
    private static final long INITIAL_TOPIC_LIST_HEAP_SIZE = 10240L;
    private Cache<CacheKey, ResultHolder> topicListSizeCache = Caffeine.newBuilder().maximumSize(10000L).build();

    public ResultHolder getTopicListSize(String namespaceName, CommandGetTopicsOfNamespace.Mode mode) {
        return this.topicListSizeCache.asMap().computeIfAbsent(new CacheKey(namespaceName, mode), __ -> new ResultHolder());
    }

    record CacheKey(String namespaceName, CommandGetTopicsOfNamespace.Mode mode) {
    }

    public static class ResultHolder {
        private final AtomicReference<CompletableFuture<Long>> topicListSizeFuture = new AtomicReference<Object>(null);

        public CompletableFuture<Long> getSizeAsync() {
            if (this.topicListSizeFuture.compareAndSet(null, new CompletableFuture())) {
                return CompletableFuture.completedFuture(10240L);
            }
            return this.topicListSizeFuture.get();
        }

        public void updateSize(long actualSize) {
            CompletableFuture<Long> currentFuture = this.topicListSizeFuture.get();
            if (currentFuture != null && !currentFuture.isDone()) {
                currentFuture.complete(actualSize);
            } else if (currentFuture == null || currentFuture.getNow(0L) != actualSize) {
                this.topicListSizeFuture.compareAndSet(currentFuture, CompletableFuture.completedFuture(actualSize));
            }
        }

        public void resetIfInitializing() {
            CompletableFuture<Long> currentFuture = this.topicListSizeFuture.getAndUpdate(value -> {
                if (value != null && !value.isDone()) {
                    return null;
                }
                return value;
            });
            if (currentFuture != null && !currentFuture.isDone()) {
                currentFuture.complete(10240L);
            }
        }
    }
}

