/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.protocol.v0_10.transport.DeliveryProperties;
import org.apache.qpid.server.protocol.v0_10.transport.MessageDeliveryPriority;
import org.apache.qpid.server.protocol.v0_10.transport.MessageProperties;

class MessageTransferHeader
implements AMQMessageHeader {
    public static final String JMS_TYPE = "x-jms-type";
    private final DeliveryProperties _deliveryProps;
    private final MessageProperties _messageProps;
    private final long _arrivalTime;

    public MessageTransferHeader(DeliveryProperties deliveryProps, MessageProperties messageProps, long arrivalTime) {
        this._deliveryProps = deliveryProps;
        this._messageProps = messageProps;
        this._arrivalTime = arrivalTime;
    }

    public String getCorrelationId() {
        if (this._messageProps != null && this._messageProps.getCorrelationId() != null) {
            return new String(this._messageProps.getCorrelationId(), StandardCharsets.UTF_8);
        }
        return null;
    }

    public long getExpiration() {
        long expiration = 0L;
        if (this._deliveryProps != null) {
            if (this._deliveryProps.hasTtl() && this._deliveryProps.getTtl() != 0L) {
                expiration = this._arrivalTime + this._deliveryProps.getTtl();
            } else if (this._deliveryProps.hasExpiration()) {
                expiration = this._deliveryProps.getExpiration();
            }
        }
        return expiration;
    }

    public String getUserId() {
        byte[] userIdBytes = this._messageProps == null ? null : this._messageProps.getUserId();
        return userIdBytes == null ? null : new String(userIdBytes, StandardCharsets.UTF_8);
    }

    public String getAppId() {
        byte[] appIdBytes = this._messageProps == null ? null : this._messageProps.getAppId();
        return appIdBytes == null ? null : new String(appIdBytes, StandardCharsets.UTF_8);
    }

    public String getGroupId() {
        Object jmsXGroupId = this.getHeader("JMSXGroupID");
        return jmsXGroupId == null ? null : String.valueOf(jmsXGroupId);
    }

    public String getMessageId() {
        UUID id = this._messageProps == null ? null : this._messageProps.getMessageId();
        return id == null ? null : "ID:" + String.valueOf(id);
    }

    public String getMimeType() {
        return this._messageProps == null ? null : this._messageProps.getContentType();
    }

    public String getEncoding() {
        return this._messageProps == null ? null : this._messageProps.getContentEncoding();
    }

    public byte getPriority() {
        MessageDeliveryPriority priority = this._deliveryProps == null || !this._deliveryProps.hasPriority() ? MessageDeliveryPriority.MEDIUM : this._deliveryProps.getPriority();
        return (byte)priority.getValue();
    }

    public long getTimestamp() {
        return this._deliveryProps == null ? 0L : this._deliveryProps.getTimestamp();
    }

    public long getNotValidBefore() {
        Object header = this.getHeader("x-qpid-not-valid-before");
        return header instanceof Number ? ((Number)header).longValue() : 0L;
    }

    public String getType() {
        Object type = this.getHeader(JMS_TYPE);
        return type instanceof String ? (String)type : null;
    }

    public String getReplyTo() {
        if (this._messageProps != null && this._messageProps.getReplyTo() != null) {
            return this._messageProps.getReplyTo().toString();
        }
        return null;
    }

    public String getReplyToExchange() {
        if (this._messageProps != null && this._messageProps.getReplyTo() != null) {
            return this._messageProps.getReplyTo().getExchange();
        }
        return null;
    }

    public String getReplyToRoutingKey() {
        if (this._messageProps != null && this._messageProps.getReplyTo() != null) {
            return this._messageProps.getReplyTo().getRoutingKey();
        }
        return null;
    }

    public Object getHeader(String name) {
        Map<String, Object> appHeaders = this._messageProps == null ? null : this._messageProps.getApplicationHeaders();
        return appHeaders == null ? null : appHeaders.get(name);
    }

    public boolean containsHeaders(Set<String> names) {
        Map<String, Object> appHeaders = this._messageProps == null ? null : this._messageProps.getApplicationHeaders();
        return appHeaders != null && appHeaders.keySet().containsAll(names);
    }

    public Collection<String> getHeaderNames() {
        Map<String, Object> appHeaders = this._messageProps == null ? null : this._messageProps.getApplicationHeaders();
        return appHeaders != null ? Collections.unmodifiableCollection(appHeaders.keySet()) : Collections.EMPTY_SET;
    }

    public boolean containsHeader(String name) {
        Map<String, Object> appHeaders = this._messageProps == null ? null : this._messageProps.getApplicationHeaders();
        return appHeaders != null && appHeaders.containsKey(name);
    }

    long getArrivalTime() {
        return this._arrivalTime;
    }
}

