/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.message.internal.InternalMessageHeader;
import org.apache.qpid.server.message.mimecontentconverter.ConversionUtils;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.v1_0.JmsMessageTypeAnnotation;
import org.apache.qpid.server.protocol.v1_0.MessageConverter_from_1_0;
import org.apache.qpid.server.protocol.v1_0.MessageMetaData_1_0;
import org.apache.qpid.server.protocol.v1_0.Message_1_0;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.codec.AMQPDescribedTypeRegistry;

@PluggableService
public class MessageConverter_v1_0_to_Internal
implements MessageConverter<Message_1_0, InternalMessage> {
    static final AMQPDescribedTypeRegistry TYPE_REGISTRY = AMQPDescribedTypeRegistry.newInstance();

    public Class<Message_1_0> getInputClass() {
        return Message_1_0.class;
    }

    public Class<InternalMessage> getOutputClass() {
        return InternalMessage.class;
    }

    public InternalMessage convert(Message_1_0 serverMessage, NamedAddressSpace addressSpace) {
        Object bodyObject = MessageConverter_from_1_0.convertBodyToObject(serverMessage);
        AMQMessageHeader convertHeader = this.convertHeader(serverMessage, addressSpace, bodyObject);
        return InternalMessage.convert((ServerMessage)serverMessage, (AMQMessageHeader)convertHeader, (Object)bodyObject);
    }

    private AMQMessageHeader convertHeader(Message_1_0 serverMessage, NamedAddressSpace addressSpace, Object convertedBodyObject) {
        String convertedMimeType = MessageConverter_v1_0_to_Internal.getInternalConvertedMimeType(serverMessage, convertedBodyObject);
        MessageMetaData_1_0.MessageHeader_1_0 messageHeader = serverMessage.getMessageHeader();
        return new InternalMessageHeader(messageHeader.getHeadersAsMap(), messageHeader.getCorrelationId(), messageHeader.getExpiration(), messageHeader.getUserId(), messageHeader.getAppId(), messageHeader.getMessageId(), convertedMimeType, messageHeader.getEncoding(), messageHeader.getPriority(), messageHeader.getTimestamp(), messageHeader.getNotValidBefore(), messageHeader.getType(), messageHeader.getReplyTo(), serverMessage.getArrivalTime());
    }

    public void dispose(InternalMessage message) {
    }

    public String getType() {
        return "v1-0 to Internal";
    }

    private static String getInternalConvertedMimeType(Message_1_0 serverMsg, Object convertedBodyObject) {
        String originalContentType;
        MessageConverter_from_1_0.ContentHint contentHint = MessageConverter_v1_0_to_Internal.getInternalTypeHint(serverMsg);
        Class<?> contentClassHint = contentHint.getContentClass();
        String mimeType = originalContentType = contentHint.getContentType();
        if (convertedBodyObject == null) {
            if (contentClassHint == Void.class || contentClassHint == Map.class || contentClassHint == List.class) {
                mimeType = null;
            } else if (contentClassHint == Serializable.class) {
                mimeType = "application/x-java-serialized-object";
            } else if (contentClassHint == byte[].class) {
                mimeType = "application/octet-stream";
            } else if (!(contentClassHint != String.class || originalContentType != null && ConversionUtils.TEXT_CONTENT_TYPES.matcher(originalContentType).matches())) {
                mimeType = "text/plain";
            }
        } else if (convertedBodyObject instanceof byte[] && originalContentType == null) {
            mimeType = contentClassHint == Serializable.class ? "application/x-java-serialized-object" : "application/octet-stream";
        } else if (convertedBodyObject instanceof List || convertedBodyObject instanceof Map) {
            mimeType = null;
        } else if (convertedBodyObject instanceof String && (originalContentType == null || !ConversionUtils.TEXT_CONTENT_TYPES.matcher(originalContentType).matches())) {
            mimeType = "text/plain";
        }
        return mimeType;
    }

    private static MessageConverter_from_1_0.ContentHint getInternalTypeHint(Message_1_0 serverMsg) {
        Symbol contentType = MessageConverter_from_1_0.getContentType(serverMsg);
        JmsMessageTypeAnnotation jmsMessageTypeAnnotation = MessageConverter_from_1_0.getJmsMessageTypeAnnotation(serverMsg);
        Class<Object> classHint = MessageConverter_from_1_0.getContentTypeClassHint(jmsMessageTypeAnnotation);
        String mimeTypeHint = null;
        if (contentType != null) {
            Class contentTypeClassHint = null;
            String type = contentType.toString();
            if (ConversionUtils.TEXT_CONTENT_TYPES.matcher(type).matches()) {
                contentTypeClassHint = String.class;
            } else if (ConversionUtils.MAP_MESSAGE_CONTENT_TYPES.matcher(type).matches()) {
                contentTypeClassHint = Map.class;
            } else if (ConversionUtils.LIST_MESSAGE_CONTENT_TYPES.matcher(type).matches()) {
                contentTypeClassHint = List.class;
            } else if (ConversionUtils.OBJECT_MESSAGE_CONTENT_TYPES.matcher(type).matches()) {
                contentTypeClassHint = Serializable.class;
            } else if (ConversionUtils.BYTES_MESSAGE_CONTENT_TYPES.matcher(type).matches()) {
                contentTypeClassHint = byte[].class;
            }
            if (classHint == null || classHint == contentTypeClassHint) {
                classHint = contentTypeClassHint;
            }
            mimeTypeHint = contentType.toString();
        }
        return new MessageConverter_from_1_0.ContentHint(classHint, mimeTypeHint);
    }

    static {
        TYPE_REGISTRY.registerTransportLayer();
        TYPE_REGISTRY.registerMessagingLayer();
        TYPE_REGISTRY.registerTransactionLayer();
        TYPE_REGISTRY.registerSecurityLayer();
    }
}

