/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.rpc;

import java.nio.ByteBuffer;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;
import org.apache.rocketmq.remoting.rpc.RpcRequest;
import org.apache.rocketmq.remoting.rpc.RpcResponse;

public class RpcClientUtils {
    public static RemotingCommand createCommandForRpcRequest(RpcRequest rpcRequest) {
        RemotingCommand cmd = RemotingCommand.createRequestCommand(rpcRequest.getCode(), rpcRequest.getHeader());
        cmd.setBody(RpcClientUtils.encodeBody(rpcRequest.getBody()));
        return cmd;
    }

    public static RemotingCommand createCommandForRpcResponse(RpcResponse rpcResponse) {
        RemotingCommand cmd = RemotingCommand.createResponseCommandWithHeader(rpcResponse.getCode(), rpcResponse.getHeader());
        cmd.setRemark(rpcResponse.getException() == null ? "" : rpcResponse.getException().getMessage());
        cmd.setBody(RpcClientUtils.encodeBody(rpcResponse.getBody()));
        return cmd;
    }

    public static byte[] encodeBody(Object body) {
        if (body == null) {
            return null;
        }
        if (body instanceof byte[]) {
            return (byte[])body;
        }
        if (body instanceof RemotingSerializable) {
            return ((RemotingSerializable)body).encode();
        }
        if (body instanceof ByteBuffer) {
            ByteBuffer buffer = (ByteBuffer)body;
            buffer.mark();
            byte[] data = new byte[buffer.remaining()];
            buffer.get(data);
            buffer.reset();
            return data;
        }
        throw new RuntimeException("Unsupported body type " + body.getClass());
    }
}

