/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.auth.migration.v1;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.rocketmq.acl.common.AclException;
import org.apache.rocketmq.acl.common.AclUtils;
import org.apache.rocketmq.auth.migration.v1.AclConfig;
import org.apache.rocketmq.auth.migration.v1.PlainAccessConfig;
import org.apache.rocketmq.auth.migration.v1.PlainAccessData;
import org.apache.rocketmq.common.MixAll;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainPermissionManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqCommon");
    private String fileHome = MixAll.ROCKETMQ_HOME_DIR;
    private String defaultAclDir;
    private String defaultAclFile;
    private List<String> fileList = new ArrayList<String>();

    public PlainPermissionManager() {
        this.defaultAclDir = MixAll.dealFilePath((String)(this.fileHome + File.separator + "conf" + File.separator + "acl"));
        this.defaultAclFile = MixAll.dealFilePath((String)(this.fileHome + File.separator + System.getProperty("rocketmq.acl.plain.file", "conf" + File.separator + "plain_acl.yml")));
        this.load();
    }

    public List<String> getAllAclFiles(String path) {
        if (!new File(path).exists()) {
            log.info("The default acl dir {} is not exist", (Object)path);
            return new ArrayList<String>();
        }
        ArrayList<String> allAclFileFullPath = new ArrayList<String>();
        File file = new File(path);
        File[] files = file.listFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            String fileName = files[i].getAbsolutePath();
            File f = new File(fileName);
            if (fileName.equals(this.fileHome + "/conf/tools.yml")) continue;
            if (fileName.endsWith(".yml") || fileName.endsWith(".yaml")) {
                allAclFileFullPath.add(fileName);
                continue;
            }
            if (!f.isDirectory()) continue;
            allAclFileFullPath.addAll(this.getAllAclFiles(fileName));
        }
        return allAclFileFullPath;
    }

    public void load() {
        if (this.fileHome == null || this.fileHome.isEmpty()) {
            return;
        }
        this.assureAclConfigFilesExist();
        this.fileList = this.getAllAclFiles(this.defaultAclDir);
        if (new File(this.defaultAclFile).exists() && !this.fileList.contains(this.defaultAclFile)) {
            this.fileList.add(this.defaultAclFile);
        }
    }

    private void assureAclConfigFilesExist() {
        Path defaultAclFilePath = Paths.get(this.defaultAclFile, new String[0]);
        if (!Files.exists(defaultAclFilePath, new LinkOption[0])) {
            try {
                Files.createFile(defaultAclFilePath, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                log.error("Error in creating " + this.defaultAclFile, (Throwable)e);
                throw new AclException(e.getMessage());
            }
        }
    }

    public AclConfig getAllAclConfig() {
        AclConfig aclConfig = new AclConfig();
        ArrayList<PlainAccessConfig> configs = new ArrayList<PlainAccessConfig>();
        ArrayList<String> whiteAddrs = new ArrayList<String>();
        HashSet<String> accessKeySets = new HashSet<String>();
        for (String path : this.fileList) {
            List<PlainAccessConfig> plainAccessConfigs;
            PlainAccessData plainAclConfData = (PlainAccessData)AclUtils.getYamlDataObject((String)path, PlainAccessData.class);
            if (plainAclConfData == null) continue;
            List<String> globalWhiteAddrs = plainAclConfData.getGlobalWhiteRemoteAddresses();
            if (globalWhiteAddrs != null && !globalWhiteAddrs.isEmpty()) {
                whiteAddrs.addAll(globalWhiteAddrs);
            }
            if ((plainAccessConfigs = plainAclConfData.getAccounts()) == null || plainAccessConfigs.isEmpty()) continue;
            for (PlainAccessConfig accessConfig : plainAccessConfigs) {
                if (accessKeySets.contains(accessConfig.getAccessKey())) continue;
                accessKeySets.add(accessConfig.getAccessKey());
                PlainAccessConfig plainAccessConfig = new PlainAccessConfig();
                plainAccessConfig.setGroupPerms(accessConfig.getGroupPerms());
                plainAccessConfig.setDefaultTopicPerm(accessConfig.getDefaultTopicPerm());
                plainAccessConfig.setDefaultGroupPerm(accessConfig.getDefaultGroupPerm());
                plainAccessConfig.setAccessKey(accessConfig.getAccessKey());
                plainAccessConfig.setSecretKey(accessConfig.getSecretKey());
                plainAccessConfig.setAdmin(accessConfig.isAdmin());
                plainAccessConfig.setTopicPerms(accessConfig.getTopicPerms());
                plainAccessConfig.setWhiteRemoteAddress(accessConfig.getWhiteRemoteAddress());
                configs.add(plainAccessConfig);
            }
        }
        aclConfig.setPlainAccessConfigs(configs);
        aclConfig.setGlobalWhiteAddrs(whiteAddrs);
        return aclConfig;
    }
}

