/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import io.netty.channel.ChannelHandlerContext;
import io.opentelemetry.api.common.Attributes;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.metrics.BrokerMetricsManager;
import org.apache.rocketmq.broker.mqtrace.SendMessageContext;
import org.apache.rocketmq.broker.processor.AbstractSendMessageProcessor;
import org.apache.rocketmq.broker.processor.SendMessageCallback;
import org.apache.rocketmq.common.AbortProcessException;
import org.apache.rocketmq.common.KeyBuilder;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.TopicFilterType;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.attribute.CleanupPolicy;
import org.apache.rocketmq.common.attribute.TopicMessageType;
import org.apache.rocketmq.common.help.FAQUrl;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageClientIDSetter;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBatch;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.common.producer.RecallMessageHandle;
import org.apache.rocketmq.common.topic.TopicValidator;
import org.apache.rocketmq.common.utils.CleanupPolicyUtils;
import org.apache.rocketmq.common.utils.MessageUtils;
import org.apache.rocketmq.common.utils.QueueTypeUtils;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.header.SendMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.SendMessageResponseHeader;
import org.apache.rocketmq.remoting.protocol.statictopic.LogicQueueMappingItem;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicQueueMappingContext;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicQueueMappingDetail;
import org.apache.rocketmq.remoting.protocol.subscription.SubscriptionGroupConfig;
import org.apache.rocketmq.remoting.rpc.TopicQueueRequestHeader;
import org.apache.rocketmq.remoting.rpc.TopicRequestHeader;
import org.apache.rocketmq.store.AppendMessageResult;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.PutMessageStatus;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.config.StorePathConfigHelper;
import org.apache.rocketmq.store.stats.BrokerStatsManager;

public class SendMessageProcessor
extends AbstractSendMessageProcessor
implements NettyRequestProcessor {
    public SendMessageProcessor(BrokerController brokerController) {
        super(brokerController);
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        switch (request.getCode()) {
            case 36: {
                return this.consumerSendMsgBack(ctx, request);
            }
        }
        SendMessageRequestHeader requestHeader = this.parseRequestHeader(request);
        if (requestHeader == null) {
            return null;
        }
        TopicQueueMappingContext mappingContext = this.brokerController.getTopicQueueMappingManager().buildTopicQueueMappingContext((TopicRequestHeader)requestHeader, true);
        RemotingCommand rewriteResult = this.brokerController.getTopicQueueMappingManager().rewriteRequestForStaticTopic((TopicQueueRequestHeader)requestHeader, mappingContext);
        if (rewriteResult != null) {
            return rewriteResult;
        }
        SendMessageContext sendMessageContext = this.buildMsgContext(ctx, requestHeader, request);
        try {
            this.executeSendMessageHookBefore(sendMessageContext);
        }
        catch (AbortProcessException e) {
            RemotingCommand errorResponse = RemotingCommand.createResponseCommand((int)e.getResponseCode(), (String)e.getErrorMessage());
            errorResponse.setOpaque(request.getOpaque());
            return errorResponse;
        }
        this.clearReservedProperties(requestHeader);
        RemotingCommand response = requestHeader.isBatch() ? this.sendBatchMessage(ctx, request, sendMessageContext, requestHeader, mappingContext, (ctx1, response1) -> this.executeSendMessageHookAfter(response1, ctx1)) : this.sendMessage(ctx, request, sendMessageContext, requestHeader, mappingContext, (ctx12, response12) -> this.executeSendMessageHookAfter(response12, ctx12));
        return response;
    }

    @Override
    public boolean rejectRequest() {
        if (!this.brokerController.getBrokerConfig().isEnableSlaveActingMaster() && this.brokerController.getMessageStoreConfig().getBrokerRole() == BrokerRole.SLAVE) {
            return true;
        }
        return this.brokerController.getMessageStore().isOSPageCacheBusy() || this.brokerController.getMessageStore().isTransientStorePoolDeficient();
    }

    private void clearReservedProperties(SendMessageRequestHeader requestHeader) {
        String properties = requestHeader.getProperties();
        properties = MessageUtils.deleteProperty((String)properties, (String)"POP_CK");
        requestHeader.setProperties(properties);
    }

    private RemotingCommand rewriteResponseForStaticTopic(SendMessageResponseHeader responseHeader, TopicQueueMappingContext mappingContext) {
        try {
            if (mappingContext.getMappingDetail() == null) {
                return null;
            }
            TopicQueueMappingDetail mappingDetail = mappingContext.getMappingDetail();
            LogicQueueMappingItem mappingItem = mappingContext.getLeaderItem();
            if (mappingItem == null) {
                return RemotingCommand.buildErrorResponse((int)501, (String)String.format("%s-%d does not exit in request process of current broker %s", mappingContext.getTopic(), mappingContext.getGlobalId(), mappingDetail.getBname()));
            }
            long staticLogicOffset = mappingItem.computeStaticQueueOffsetLoosely(responseHeader.getQueueOffset().longValue());
            if (staticLogicOffset < 0L) {
                // empty if block
            }
            responseHeader.setQueueId(mappingContext.getGlobalId());
            responseHeader.setQueueOffset(Long.valueOf(staticLogicOffset));
        }
        catch (Throwable t) {
            return RemotingCommand.buildErrorResponse((int)1, (String)t.getMessage());
        }
        return null;
    }

    private boolean handleRetryAndDLQ(SendMessageRequestHeader requestHeader, RemotingCommand response, RemotingCommand request, MessageExt msg, TopicConfig topicConfig, Map<String, String> properties) {
        String newTopic = requestHeader.getTopic();
        if (null != newTopic && newTopic.startsWith("%RETRY%")) {
            String groupName = KeyBuilder.parseGroup((String)newTopic);
            SubscriptionGroupConfig subscriptionGroupConfig = this.brokerController.getSubscriptionGroupManager().findSubscriptionGroupConfig(groupName);
            if (null == subscriptionGroupConfig) {
                response.setCode(26);
                response.setRemark("subscription group not exist, " + groupName + " " + FAQUrl.suggestTodo((String)"https://rocketmq.apache.org/docs/bestPractice/06FAQ"));
                return false;
            }
            int maxReconsumeTimes = subscriptionGroupConfig.getRetryMaxTimes();
            if (request.getVersion() >= MQVersion.Version.V3_4_9.ordinal() && requestHeader.getMaxReconsumeTimes() != null) {
                maxReconsumeTimes = requestHeader.getMaxReconsumeTimes();
            }
            int reconsumeTimes = requestHeader.getReconsumeTimes() == null ? 0 : requestHeader.getReconsumeTimes();
            boolean sendRetryMessageToDeadLetterQueueDirectly = false;
            if (!this.brokerController.getRebalanceLockManager().isLockAllExpired(groupName)) {
                LOGGER.info("Group has unexpired lock record, which show it is ordered message, send it to DLQ right now group={}, topic={}, reconsumeTimes={}, maxReconsumeTimes={}.", new Object[]{groupName, newTopic, reconsumeTimes, maxReconsumeTimes});
                sendRetryMessageToDeadLetterQueueDirectly = true;
            }
            if (reconsumeTimes > maxReconsumeTimes || sendRetryMessageToDeadLetterQueueDirectly) {
                Attributes attributes = this.brokerController.getBrokerMetricsManager().newAttributesBuilder().put("consumer_group", requestHeader.getProducerGroup()).put("topic", requestHeader.getTopic()).put("is_system", BrokerMetricsManager.isSystem(requestHeader.getTopic(), requestHeader.getProducerGroup())).build();
                this.brokerController.getBrokerMetricsManager().getSendToDlqMessages().add(1L, attributes);
                properties.put("DELAY", "-1");
                newTopic = MixAll.getDLQTopic((String)groupName);
                int queueIdInt = this.randomQueueId(1);
                topicConfig = this.brokerController.getTopicConfigManager().createTopicInSendMessageBackMethod(newTopic, 1, 6, 0);
                msg.setTopic(newTopic);
                msg.setQueueId(queueIdInt);
                msg.setDelayTimeLevel(0);
                if (null == topicConfig) {
                    response.setCode(1);
                    response.setRemark("topic[" + newTopic + "] not exist");
                    return false;
                }
            }
        }
        int sysFlag = requestHeader.getSysFlag();
        if (TopicFilterType.MULTI_TAG == topicConfig.getTopicFilterType()) {
            sysFlag |= 2;
        }
        msg.setSysFlag(sysFlag);
        return true;
    }

    public RemotingCommand sendMessage(ChannelHandlerContext ctx, RemotingCommand request, SendMessageContext sendMessageContext, SendMessageRequestHeader requestHeader, TopicQueueMappingContext mappingContext, SendMessageCallback sendMessageCallback) throws RemotingCommandException {
        boolean sendTransactionPrepareMessage;
        RemotingCommand response = this.preSend(ctx, request, requestHeader);
        if (response.getCode() != -1) {
            return response;
        }
        SendMessageResponseHeader responseHeader = (SendMessageResponseHeader)response.readCustomHeader();
        byte[] body = request.getBody();
        int queueIdInt = requestHeader.getQueueId();
        TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(requestHeader.getTopic());
        if (queueIdInt < 0) {
            queueIdInt = this.randomQueueId(topicConfig.getWriteQueueNums());
        }
        MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
        msgInner.setTopic(requestHeader.getTopic());
        msgInner.setQueueId(queueIdInt);
        Map oriProps = MessageDecoder.string2messageProperties((String)requestHeader.getProperties());
        if (!this.handleRetryAndDLQ(requestHeader, response, request, (MessageExt)msgInner, topicConfig, oriProps)) {
            return response;
        }
        msgInner.setBody(body);
        msgInner.setFlag(requestHeader.getFlag().intValue());
        String uniqKey = (String)oriProps.get("UNIQ_KEY");
        if (uniqKey == null || uniqKey.length() <= 0) {
            uniqKey = MessageClientIDSetter.createUniqID();
            oriProps.put("UNIQ_KEY", uniqKey);
        }
        MessageAccessor.setProperties((Message)msgInner, (Map)oriProps);
        CleanupPolicy cleanupPolicy = CleanupPolicyUtils.getDeletePolicy(Optional.of(topicConfig));
        if (Objects.equals(cleanupPolicy, CleanupPolicy.COMPACTION) && StringUtils.isBlank((CharSequence)msgInner.getKeys())) {
            response.setCode(13);
            response.setRemark("Required message key is missing");
            return response;
        }
        msgInner.setTagsCode(MessageExtBrokerInner.tagsString2tagsCode((TopicFilterType)topicConfig.getTopicFilterType(), (String)msgInner.getTags()));
        msgInner.setBornTimestamp(requestHeader.getBornTimestamp().longValue());
        msgInner.setBornHost(ctx.channel().remoteAddress());
        msgInner.setStoreHost(this.getStoreHost());
        msgInner.setReconsumeTimes(requestHeader.getReconsumeTimes() == null ? 0 : requestHeader.getReconsumeTimes());
        String clusterName = this.brokerController.getBrokerConfig().getBrokerClusterName();
        MessageAccessor.putProperty((Message)msgInner, (String)"CLUSTER", (String)clusterName);
        msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgInner.getProperties()));
        String traFlag = (String)oriProps.get("TRAN_MSG");
        if (Boolean.parseBoolean(traFlag) && (msgInner.getReconsumeTimes() <= 0 || msgInner.getDelayTimeLevel() <= 0)) {
            if (this.brokerController.getBrokerConfig().isRejectTransactionMessage()) {
                response.setCode(16);
                response.setRemark("the broker[" + this.brokerController.getBrokerConfig().getBrokerIP1() + "] sending transaction message is forbidden");
                return response;
            }
            sendTransactionPrepareMessage = true;
        } else {
            sendTransactionPrepareMessage = false;
        }
        long beginTimeMillis = this.brokerController.getMessageStore().now();
        if (this.brokerController.getBrokerConfig().isAsyncSendEnable()) {
            CompletableFuture asyncPutMessageFuture = sendTransactionPrepareMessage ? this.brokerController.getTransactionalMessageService().asyncPrepareMessage(msgInner) : this.brokerController.getMessageStore().asyncPutMessage(msgInner);
            int finalQueueIdInt = queueIdInt;
            MessageExtBrokerInner finalMsgInner = msgInner;
            asyncPutMessageFuture.thenAcceptAsync(putMessageResult -> {
                RemotingCommand responseFuture = this.handlePutMessageResult((PutMessageResult)putMessageResult, response, request, (MessageExt)finalMsgInner, responseHeader, sendMessageContext, ctx, finalQueueIdInt, beginTimeMillis, mappingContext, BrokerMetricsManager.getMessageType(requestHeader));
                if (responseFuture != null) {
                    this.doResponse(ctx, request, responseFuture);
                }
                if (sendTransactionPrepareMessage && (responseFuture == null || responseFuture.getCode() == 0)) {
                    this.brokerController.getTransactionalMessageService().getTransactionMetrics().addAndGet(msgInner.getProperty("REAL_TOPIC"), 1);
                }
                sendMessageCallback.onComplete(sendMessageContext, response);
            }, (Executor)this.brokerController.getPutMessageFutureExecutor());
            return null;
        }
        PutMessageResult putMessageResult2 = null;
        putMessageResult2 = sendTransactionPrepareMessage ? this.brokerController.getTransactionalMessageService().prepareMessage(msgInner) : this.brokerController.getMessageStore().putMessage(msgInner);
        this.handlePutMessageResult(putMessageResult2, response, request, (MessageExt)msgInner, responseHeader, sendMessageContext, ctx, queueIdInt, beginTimeMillis, mappingContext, BrokerMetricsManager.getMessageType(requestHeader));
        if (sendTransactionPrepareMessage && putMessageResult2.getPutMessageStatus() == PutMessageStatus.PUT_OK && putMessageResult2.getAppendMessageResult().isOk()) {
            this.brokerController.getTransactionalMessageService().getTransactionMetrics().addAndGet(msgInner.getProperty("REAL_TOPIC"), 1);
        }
        sendMessageCallback.onComplete(sendMessageContext, response);
        return response;
    }

    private RemotingCommand handlePutMessageResult(PutMessageResult putMessageResult, RemotingCommand response, RemotingCommand request, MessageExt msg, SendMessageResponseHeader responseHeader, SendMessageContext sendMessageContext, ChannelHandlerContext ctx, int queueIdInt, long beginTimeMillis, TopicQueueMappingContext mappingContext, TopicMessageType messageType) {
        if (putMessageResult == null) {
            response.setCode(1);
            response.setRemark("store putMessage return null");
            return response;
        }
        boolean sendOK = false;
        switch (putMessageResult.getPutMessageStatus()) {
            case PUT_OK: {
                sendOK = true;
                response.setCode(0);
                break;
            }
            case FLUSH_DISK_TIMEOUT: {
                response.setCode(10);
                sendOK = true;
                break;
            }
            case FLUSH_SLAVE_TIMEOUT: {
                response.setCode(12);
                sendOK = true;
                break;
            }
            case SLAVE_NOT_AVAILABLE: {
                response.setCode(11);
                sendOK = true;
                break;
            }
            case IN_SYNC_REPLICAS_NOT_ENOUGH: {
                response.setCode(1);
                response.setRemark("in-sync replicas not enough");
                break;
            }
            case CREATE_MAPPED_FILE_FAILED: {
                response.setCode(1);
                response.setRemark("create mapped file failed, server is busy or broken.");
                break;
            }
            case MESSAGE_ILLEGAL: 
            case PROPERTIES_SIZE_EXCEEDED: {
                response.setCode(13);
                response.setRemark(String.format("the message is illegal, maybe msg body or properties length not matched. msg body length limit %dB, msg properties length limit 32KB.", this.brokerController.getMessageStoreConfig().getMaxMessageSize()));
                break;
            }
            case WHEEL_TIMER_MSG_ILLEGAL: {
                response.setCode(13);
                response.setRemark(String.format("timer message illegal, the delay time should not be bigger than the max delay %dms; or if set del msg, the delay time should be bigger than the current time", (long)this.brokerController.getMessageStoreConfig().getTimerMaxDelaySec() * 1000L));
                break;
            }
            case WHEEL_TIMER_FLOW_CONTROL: {
                response.setCode(1);
                response.setRemark(String.format("timer message is under flow control, max num limit is %d or the current value is greater than %d and less than %d, trigger random flow control", (long)this.brokerController.getMessageStoreConfig().getTimerCongestNumEachSlot() * 2L, this.brokerController.getMessageStoreConfig().getTimerCongestNumEachSlot(), (long)this.brokerController.getMessageStoreConfig().getTimerCongestNumEachSlot() * 2L));
                break;
            }
            case WHEEL_TIMER_NOT_ENABLE: {
                response.setCode(1);
                response.setRemark(String.format("accurate timer message is not enabled, timerWheelEnable is %s", this.brokerController.getMessageStoreConfig().isTimerWheelEnable()));
                break;
            }
            case SERVICE_NOT_AVAILABLE: {
                response.setCode(14);
                response.setRemark("service not available now. It may be caused by one of the following reasons: the broker's disk is full [" + this.diskUtil() + "], messages are put to the slave, message store has been shut down, etc.");
                break;
            }
            case OS_PAGE_CACHE_BUSY: {
                response.setCode(2);
                response.setRemark("[PC_SYNCHRONIZED]broker busy, start flow control for a while");
                break;
            }
            case LMQ_CONSUME_QUEUE_NUM_EXCEEDED: {
                response.setCode(1);
                response.setRemark("[LMQ_CONSUME_QUEUE_NUM_EXCEEDED]broker config enableLmq and enableMultiDispatch, lmq consumeQueue num exceed maxLmqConsumeQueueNum config num, default limit 2w.");
                break;
            }
            case UNKNOWN_ERROR: {
                response.setCode(1);
                response.setRemark("UNKNOWN_ERROR");
                break;
            }
            default: {
                response.setCode(1);
                response.setRemark("UNKNOWN_ERROR DEFAULT");
            }
        }
        String owner = (String)request.getExtFields().get("Owner");
        String authType = (String)request.getExtFields().get("AUTH_TYPE");
        String ownerParent = (String)request.getExtFields().get("OWNER_PARENT");
        String ownerSelf = (String)request.getExtFields().get("OWNER_SELF");
        int commercialSizePerMsg = this.brokerController.getBrokerConfig().getCommercialSizePerMsg();
        if (sendOK) {
            if ("SCHEDULE_TOPIC_XXXX".equals(msg.getTopic())) {
                this.brokerController.getBrokerStatsManager().incQueuePutNums(msg.getTopic(), Integer.valueOf(msg.getQueueId()), putMessageResult.getAppendMessageResult().getMsgNum(), 1);
                this.brokerController.getBrokerStatsManager().incQueuePutSize(msg.getTopic(), Integer.valueOf(msg.getQueueId()), putMessageResult.getAppendMessageResult().getWroteBytes());
            }
            this.brokerController.getBrokerStatsManager().incTopicPutNums(msg.getTopic(), putMessageResult.getAppendMessageResult().getMsgNum(), 1);
            this.brokerController.getBrokerStatsManager().incTopicPutSize(msg.getTopic(), putMessageResult.getAppendMessageResult().getWroteBytes());
            this.brokerController.getBrokerStatsManager().incBrokerPutNums(msg.getTopic(), putMessageResult.getAppendMessageResult().getMsgNum());
            this.brokerController.getBrokerStatsManager().incTopicPutLatency(msg.getTopic(), queueIdInt, (int)(this.brokerController.getMessageStore().now() - beginTimeMillis));
            if (!BrokerMetricsManager.isRetryOrDlqTopic(msg.getTopic())) {
                Attributes attributes = this.brokerController.getBrokerMetricsManager().newAttributesBuilder().put("topic", msg.getTopic()).put("message_type", messageType.getMetricsValue()).put("is_system", TopicValidator.isSystemTopic((String)msg.getTopic())).build();
                this.brokerController.getBrokerMetricsManager().getMessagesInTotal().add((long)putMessageResult.getAppendMessageResult().getMsgNum(), attributes);
                this.brokerController.getBrokerMetricsManager().getThroughputInTotal().add((long)putMessageResult.getAppendMessageResult().getWroteBytes(), attributes);
                this.brokerController.getBrokerMetricsManager().getMessageSize().record((long)(putMessageResult.getAppendMessageResult().getWroteBytes() / putMessageResult.getAppendMessageResult().getMsgNum()), attributes);
            }
            response.setRemark(null);
            responseHeader.setMsgId(putMessageResult.getAppendMessageResult().getMsgId());
            responseHeader.setQueueId(Integer.valueOf(queueIdInt));
            responseHeader.setQueueOffset(Long.valueOf(putMessageResult.getAppendMessageResult().getLogicsOffset()));
            responseHeader.setTransactionId(MessageClientIDSetter.getUniqID((Message)msg));
            this.attachRecallHandle(request, msg, responseHeader);
            RemotingCommand rewriteResult = this.rewriteResponseForStaticTopic(responseHeader, mappingContext);
            if (rewriteResult != null) {
                return rewriteResult;
            }
            this.doResponse(ctx, request, response);
            if (this.hasSendMessageHook()) {
                sendMessageContext.setMsgId(responseHeader.getMsgId());
                sendMessageContext.setQueueId(responseHeader.getQueueId());
                sendMessageContext.setQueueOffset(responseHeader.getQueueOffset());
                int commercialBaseCount = this.brokerController.getBrokerConfig().getCommercialBaseCount();
                int wroteSize = putMessageResult.getAppendMessageResult().getWroteBytes();
                int msgNum = putMessageResult.getAppendMessageResult().getMsgNum();
                int commercialMsgNum = (int)Math.ceil((double)wroteSize / (double)commercialSizePerMsg);
                int incValue = commercialMsgNum * commercialBaseCount;
                sendMessageContext.setCommercialSendStats(BrokerStatsManager.StatsType.SEND_SUCCESS);
                sendMessageContext.setCommercialSendTimes(incValue);
                sendMessageContext.setCommercialSendSize(wroteSize);
                sendMessageContext.setCommercialOwner(owner);
                sendMessageContext.setSendStat(BrokerStatsManager.StatsType.SEND_SUCCESS);
                sendMessageContext.setCommercialSendMsgNum(commercialMsgNum);
                sendMessageContext.setAccountAuthType(authType);
                sendMessageContext.setAccountOwnerParent(ownerParent);
                sendMessageContext.setAccountOwnerSelf(ownerSelf);
                sendMessageContext.setSendMsgSize(wroteSize);
                sendMessageContext.setSendMsgNum(msgNum);
            }
            return null;
        }
        if (this.hasSendMessageHook()) {
            AppendMessageResult appendMessageResult = putMessageResult.getAppendMessageResult();
            int wroteSize = request.getBody().length;
            int msgNum = Math.max(appendMessageResult != null ? appendMessageResult.getMsgNum() : 1, 1);
            int commercialMsgNum = (int)Math.ceil((double)wroteSize / (double)commercialSizePerMsg);
            sendMessageContext.setCommercialSendStats(BrokerStatsManager.StatsType.SEND_FAILURE);
            sendMessageContext.setCommercialSendTimes(commercialMsgNum);
            sendMessageContext.setCommercialSendSize(wroteSize);
            sendMessageContext.setCommercialOwner(owner);
            sendMessageContext.setSendStat(BrokerStatsManager.StatsType.SEND_FAILURE);
            sendMessageContext.setCommercialSendMsgNum(commercialMsgNum);
            sendMessageContext.setAccountAuthType(authType);
            sendMessageContext.setAccountOwnerParent(ownerParent);
            sendMessageContext.setAccountOwnerSelf(ownerSelf);
            sendMessageContext.setSendMsgSize(wroteSize);
            sendMessageContext.setSendMsgNum(msgNum);
        }
        return response;
    }

    private RemotingCommand sendBatchMessage(ChannelHandlerContext ctx, RemotingCommand request, SendMessageContext sendMessageContext, SendMessageRequestHeader requestHeader, TopicQueueMappingContext mappingContext, SendMessageCallback sendMessageCallback) {
        RemotingCommand response = this.preSend(ctx, request, requestHeader);
        SendMessageResponseHeader responseHeader = (SendMessageResponseHeader)response.readCustomHeader();
        if (response.getCode() != -1) {
            return response;
        }
        int queueIdInt = requestHeader.getQueueId();
        TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(requestHeader.getTopic());
        if (queueIdInt < 0) {
            queueIdInt = this.randomQueueId(topicConfig.getWriteQueueNums());
        }
        if (requestHeader.getTopic().length() > 127) {
            response.setCode(13);
            response.setRemark("message topic length too long " + requestHeader.getTopic().length());
            return response;
        }
        if (requestHeader.getTopic() != null && requestHeader.getTopic().startsWith("%RETRY%")) {
            response.setCode(13);
            response.setRemark("batch request does not support retry group " + requestHeader.getTopic());
            return response;
        }
        MessageExtBatch messageExtBatch = new MessageExtBatch();
        messageExtBatch.setTopic(requestHeader.getTopic());
        messageExtBatch.setQueueId(queueIdInt);
        int sysFlag = requestHeader.getSysFlag();
        if (TopicFilterType.MULTI_TAG == topicConfig.getTopicFilterType()) {
            sysFlag |= 2;
        }
        messageExtBatch.setSysFlag(sysFlag);
        messageExtBatch.setFlag(requestHeader.getFlag().intValue());
        MessageAccessor.setProperties((Message)messageExtBatch, (Map)MessageDecoder.string2messageProperties((String)requestHeader.getProperties()));
        messageExtBatch.setBody(request.getBody());
        messageExtBatch.setBornTimestamp(requestHeader.getBornTimestamp().longValue());
        messageExtBatch.setBornHost(ctx.channel().remoteAddress());
        messageExtBatch.setStoreHost(this.getStoreHost());
        messageExtBatch.setReconsumeTimes(requestHeader.getReconsumeTimes() == null ? 0 : requestHeader.getReconsumeTimes());
        String clusterName = this.brokerController.getBrokerConfig().getBrokerClusterName();
        MessageAccessor.putProperty((Message)messageExtBatch, (String)"CLUSTER", (String)clusterName);
        boolean isInnerBatch = false;
        if (QueueTypeUtils.isBatchCq(Optional.of(topicConfig)) && MessageClientIDSetter.getUniqID((Message)messageExtBatch) != null) {
            messageExtBatch.setSysFlag(messageExtBatch.getSysFlag() | 0x40);
            messageExtBatch.setSysFlag(messageExtBatch.getSysFlag() | 0x80);
            messageExtBatch.setInnerBatch(true);
            int innerNum = MessageDecoder.countInnerMsgNum((ByteBuffer)ByteBuffer.wrap(messageExtBatch.getBody()));
            MessageAccessor.putProperty((Message)messageExtBatch, (String)"INNER_NUM", (String)String.valueOf(innerNum));
            messageExtBatch.setPropertiesString(MessageDecoder.messageProperties2String((Map)messageExtBatch.getProperties()));
            responseHeader.setBatchUniqId(MessageClientIDSetter.getUniqID((Message)messageExtBatch));
            isInnerBatch = true;
        }
        long beginTimeMillis = this.brokerController.getMessageStore().now();
        if (this.brokerController.getBrokerConfig().isAsyncSendEnable()) {
            CompletableFuture asyncPutMessageFuture = isInnerBatch ? this.brokerController.getMessageStore().asyncPutMessage((MessageExtBrokerInner)messageExtBatch) : this.brokerController.getMessageStore().asyncPutMessages(messageExtBatch);
            int finalQueueIdInt = queueIdInt;
            asyncPutMessageFuture.thenAcceptAsync(putMessageResult -> {
                RemotingCommand responseFuture = this.handlePutMessageResult((PutMessageResult)putMessageResult, response, request, (MessageExt)messageExtBatch, responseHeader, sendMessageContext, ctx, finalQueueIdInt, beginTimeMillis, mappingContext, BrokerMetricsManager.getMessageType(requestHeader));
                if (responseFuture != null) {
                    this.doResponse(ctx, request, responseFuture);
                }
                sendMessageCallback.onComplete(sendMessageContext, response);
            }, (Executor)this.brokerController.getSendMessageExecutor());
            return null;
        }
        PutMessageResult putMessageResult2 = isInnerBatch ? this.brokerController.getMessageStore().putMessage((MessageExtBrokerInner)messageExtBatch) : this.brokerController.getMessageStore().putMessages(messageExtBatch);
        this.handlePutMessageResult(putMessageResult2, response, request, (MessageExt)messageExtBatch, responseHeader, sendMessageContext, ctx, queueIdInt, beginTimeMillis, mappingContext, BrokerMetricsManager.getMessageType(requestHeader));
        sendMessageCallback.onComplete(sendMessageContext, response);
        return response;
    }

    public void attachRecallHandle(RemotingCommand request, MessageExt msg, SendMessageResponseHeader responseHeader) {
        if (320 == request.getCode() || 36 == request.getCode()) {
            return;
        }
        String timestampStr = msg.getProperty("TIMER_OUT_MS");
        String realTopic = msg.getProperty("REAL_TOPIC");
        if (timestampStr != null && realTopic != null && !realTopic.startsWith("%RETRY%")) {
            timestampStr = String.valueOf(Long.parseLong(timestampStr) + 1L);
            String recallHandle = RecallMessageHandle.HandleV1.buildHandle((String)realTopic, (String)this.brokerController.getBrokerConfig().getBrokerName(), (String)timestampStr, (String)MessageClientIDSetter.getUniqID((Message)msg));
            responseHeader.setRecallHandle(recallHandle);
        }
    }

    private String diskUtil() {
        String[] paths;
        double physicRatio = 100.0;
        MessageStore messageStore = this.brokerController.getMessageStore();
        String storePath = messageStore instanceof DefaultMessageStore ? ((DefaultMessageStore)messageStore).getStorePathPhysic() : this.brokerController.getMessageStoreConfig().getStorePathCommitLog();
        for (String storePathPhysic : paths = storePath.trim().split(MixAll.MULTI_PATH_SPLITTER)) {
            physicRatio = Math.min(physicRatio, UtilAll.getDiskPartitionSpaceUsedPercent((String)storePathPhysic));
        }
        String storePathLogis = StorePathConfigHelper.getStorePathConsumeQueue((String)this.brokerController.getMessageStoreConfig().getStorePathRootDir());
        double logisRatio = UtilAll.getDiskPartitionSpaceUsedPercent((String)storePathLogis);
        String storePathIndex = StorePathConfigHelper.getStorePathIndex((String)this.brokerController.getMessageStoreConfig().getStorePathRootDir());
        double indexRatio = UtilAll.getDiskPartitionSpaceUsedPercent((String)storePathIndex);
        return String.format("CL: %5.2f CQ: %5.2f INDEX: %5.2f", physicRatio, logisRatio, indexRatio);
    }

    private RemotingCommand preSend(ChannelHandlerContext ctx, RemotingCommand request, SendMessageRequestHeader requestHeader) {
        RemotingCommand response = RemotingCommand.createResponseCommand(SendMessageResponseHeader.class);
        response.setOpaque(request.getOpaque());
        response.addExtField("MSG_REGION", this.brokerController.getBrokerConfig().getRegionId());
        response.addExtField("TRACE_ON", String.valueOf(this.brokerController.getBrokerConfig().isTraceOn()));
        LOGGER.debug("Receive SendMessage request command {}", (Object)request);
        long startTimestamp = this.brokerController.getBrokerConfig().getStartAcceptSendRequestTimeStamp();
        if (this.brokerController.getMessageStore().now() < startTimestamp) {
            response.setCode(1);
            response.setRemark(String.format("broker unable to service, until %s", UtilAll.timeMillisToHumanString2((long)startTimestamp)));
            return response;
        }
        response.setCode(-1);
        super.msgCheck(ctx, requestHeader, request, response);
        return response;
    }
}

