/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.example.simple;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.consumer.AllocateMessageQueueStrategy;
import org.apache.rocketmq.client.consumer.DefaultMQPullConsumer;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.PullResult;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.rebalance.AllocateMessageQueueAveragely;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.remoting.RPCHook;

public class AclClient {
    private static final Map<MessageQueue, Long> OFFSE_TABLE = new HashMap<MessageQueue, Long>();
    private static final String ACL_ACCESS_KEY = "RocketMQ";
    private static final String ACL_SECRET_KEY = "1234567";

    public static void main(String[] args) throws MQClientException, InterruptedException {
        AclClient.producer();
        AclClient.pushConsumer();
        AclClient.pullConsumer();
    }

    public static void producer() throws MQClientException {
        DefaultMQProducer producer = new DefaultMQProducer("ProducerGroupName", AclClient.getAclRPCHook());
        producer.setNamesrvAddr("127.0.0.1:9876");
        producer.start();
        for (int i = 0; i < 128; ++i) {
            try {
                Message msg = new Message("TopicTest", "TagA", "OrderID188", "Hello world".getBytes("UTF-8"));
                SendResult sendResult = producer.send(msg);
                System.out.printf("%s%n", sendResult);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        producer.shutdown();
    }

    public static void pushConsumer() throws MQClientException {
        DefaultMQPushConsumer consumer = new DefaultMQPushConsumer("please_rename_unique_group_name_5", AclClient.getAclRPCHook(), (AllocateMessageQueueStrategy)new AllocateMessageQueueAveragely());
        consumer.setNamesrvAddr("127.0.0.1:9876");
        consumer.subscribe("TopicTest", "*");
        consumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_FIRST_OFFSET);
        consumer.setConsumeTimestamp("20180422221800");
        consumer.registerMessageListener(new MessageListenerConcurrently(){

            public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
                System.out.printf("%s Receive New Messages: %s %n", Thread.currentThread().getName(), msgs);
                AclClient.printBody(msgs);
                return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
            }
        });
        consumer.start();
        System.out.printf("Consumer Started.%n", new Object[0]);
    }

    public static void pullConsumer() throws MQClientException {
        DefaultMQPullConsumer consumer = new DefaultMQPullConsumer("please_rename_unique_group_name_6", AclClient.getAclRPCHook());
        consumer.setNamesrvAddr("127.0.0.1:9876");
        consumer.start();
        Set mqs = consumer.fetchSubscribeMessageQueues("TopicTest");
        block8: for (MessageQueue mq : mqs) {
            System.out.printf("Consume from the queue: %s%n", mq);
            while (true) {
                try {
                    while (true) {
                        PullResult pullResult = consumer.pullBlockIfNotFound(mq, null, AclClient.getMessageQueueOffset(mq), 32);
                        System.out.printf("%s%n", pullResult);
                        AclClient.putMessageQueueOffset(mq, pullResult.getNextBeginOffset());
                        AclClient.printBody(pullResult);
                        switch (pullResult.getPullStatus()) {
                            case FOUND: {
                                break;
                            }
                            case NO_MATCHED_MSG: {
                                break;
                            }
                            case NO_NEW_MSG: {
                                continue block8;
                            }
                            case OFFSET_ILLEGAL: {
                                break;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
        consumer.shutdown();
    }

    private static void printBody(PullResult pullResult) {
        AclClient.printBody(pullResult.getMsgFoundList());
    }

    private static void printBody(List<MessageExt> msg) {
        if (msg == null || msg.size() == 0) {
            return;
        }
        for (MessageExt m : msg) {
            if (m == null) continue;
            System.out.printf("msgId : %s  body : %s  \n\r", m.getMsgId(), new String(m.getBody(), StandardCharsets.UTF_8));
        }
    }

    private static long getMessageQueueOffset(MessageQueue mq) {
        Long offset = OFFSE_TABLE.get(mq);
        if (offset != null) {
            return offset;
        }
        return 0L;
    }

    private static void putMessageQueueOffset(MessageQueue mq, long offset) {
        OFFSE_TABLE.put(mq, offset);
    }

    static RPCHook getAclRPCHook() {
        return new AclClientRPCHook(new SessionCredentials(ACL_ACCESS_KEY, ACL_SECRET_KEY));
    }
}

