/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.extend.property;

import io.swagger.models.Xml;
import io.swagger.models.properties.BaseIntegerProperty;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractBaseIntegerProperty<T>
extends BaseIntegerProperty {
    protected T defaultValue;
    protected List<T> enumNames;

    public AbstractBaseIntegerProperty(String format) {
        super(format);
    }

    public AbstractBaseIntegerProperty<T> addEnum(T value) {
        if (this.enumNames == null) {
            this.enumNames = new ArrayList<T>();
        }
        if (!this.enumNames.contains(value)) {
            this.enumNames.add(value);
        }
        return this;
    }

    public AbstractBaseIntegerProperty<T> replaceEnum(List<T> value) {
        this.enumNames = value;
        return this;
    }

    public AbstractBaseIntegerProperty<T> xml(Xml xml) {
        this.setXml(xml);
        return this;
    }

    public AbstractBaseIntegerProperty<T> readOnly() {
        this.setReadOnly(Boolean.TRUE);
        return this;
    }

    protected abstract T parseNumber(String var1);

    public AbstractBaseIntegerProperty<T> assignDefault(String defaultValue) {
        if (defaultValue != null) {
            try {
                this.defaultValue = this.parseNumber(defaultValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this;
    }

    public AbstractBaseIntegerProperty<T> assignDefault(T defaultValue) {
        this.setDefault(defaultValue);
        return this;
    }

    public AbstractBaseIntegerProperty<T> vendorExtension(String key, Object obj) {
        this.setVendorExtension(key, obj);
        return this;
    }

    public T getDefault() {
        return this.defaultValue;
    }

    public void setDefault(String defaultValue) {
        this.assignDefault((T)defaultValue);
    }

    public void setDefault(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public List<T> getEnum() {
        return this.enumNames;
    }

    public void setEnum(List<T> enums) {
        this.enumNames = enums;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AbstractBaseIntegerProperty)) {
            return false;
        }
        AbstractBaseIntegerProperty other = (AbstractBaseIntegerProperty)((Object)obj);
        return !(this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue));
    }
}

