/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.query;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.servicecomb.common.rest.codec.query.QueryCodec;
import org.apache.servicecomb.common.rest.codec.query.QueryCodecCsv;
import org.apache.servicecomb.common.rest.codec.query.QueryCodecMulti;
import org.apache.servicecomb.common.rest.codec.query.QueryCodecPipes;
import org.apache.servicecomb.common.rest.codec.query.QueryCodecSsv;
import org.apache.servicecomb.common.rest.codec.query.QueryCodecTsv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class QueryCodecs {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryCodecs.class);
    private final Map<String, QueryCodec> codecs = new HashMap<String, QueryCodec>();
    private final QueryCodec defaultCodec;

    static QueryCodecs createForTest() {
        return new QueryCodecs(Arrays.asList(new QueryCodecMulti(), new QueryCodecCsv(), new QueryCodecSsv(), new QueryCodecTsv(), new QueryCodecPipes()));
    }

    public QueryCodecs(List<QueryCodec> orderedCodecs) {
        orderedCodecs.forEach(this::register);
        this.defaultCodec = this.codecs.get("multi");
    }

    private void register(@Nonnull QueryCodec codec) {
        QueryCodec exists = this.codecs.put(codec.getCodecName(), codec);
        if (exists != null) {
            LOGGER.info("override QueryCodec, exists={}, new={}.", (Object)exists.getClass().getName(), (Object)codec.getClass().getName());
        }
    }

    @Nonnull
    public QueryCodec find(@Nullable String name) {
        if (name == null) {
            return this.defaultCodec;
        }
        QueryCodec codec = this.codecs.get(name);
        if (codec == null) {
            throw new IllegalStateException("not support QueryCodec, name=" + name);
        }
        return codec;
    }
}

