/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.stream;

import io.netty.buffer.ByteBuf;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.buffer.impl.VertxByteBufAllocator;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class BufferOutputStream
extends OutputStream {
    private static final int DIRECT_BUFFER_SIZE = 1024;
    protected ByteBuf byteBuf;

    public BufferOutputStream() {
        this(VertxByteBufAllocator.DEFAULT.heapBuffer(1024, Integer.MAX_VALUE));
    }

    public BufferOutputStream(ByteBuf buffer) {
        this.byteBuf = buffer;
    }

    public ByteBuf getByteBuf() {
        return this.byteBuf;
    }

    public Buffer getBuffer() {
        return Buffer.buffer((ByteBuf)this.byteBuf);
    }

    public int length() {
        return this.byteBuf.readableBytes();
    }

    public void writeByte(byte value) {
        this.byteBuf.writeByte((int)value);
    }

    @Override
    public void write(int byteValue) {
        this.byteBuf.writeByte((int)((byte)byteValue));
    }

    public void write(boolean value) {
        this.byteBuf.writeBoolean(value);
    }

    public void writeInt(int pos, int value) {
        this.byteBuf.setInt(pos, value);
    }

    public void writeShort(short value) {
        this.byteBuf.writeShort((int)value);
    }

    public void writeInt(int value) {
        this.byteBuf.writeInt(value);
    }

    public void writeLong(long value) {
        this.byteBuf.writeLong(value);
    }

    public void writeString(String value) {
        this.byteBuf.writeInt(value.length());
        this.byteBuf.writeCharSequence((CharSequence)value, StandardCharsets.UTF_8);
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int len) {
        this.byteBuf.writeBytes(bytes, offset, len);
    }

    @Override
    public void close() {
    }

    public int writerIndex() {
        return this.byteBuf.writerIndex();
    }
}

