/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.map;

import io.protostuff.InputEx;
import io.protostuff.OutputEx;
import io.protostuff.SchemaEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.servicecomb.foundation.common.utils.bean.Getter;
import org.apache.servicecomb.foundation.common.utils.bean.Setter;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.map.MapEntry;
import org.apache.servicecomb.foundation.protobuf.internal.schema.map.MapEntrySchema;

public class MapSchema<T>
extends FieldSchema<T> {
    private final Getter<T, Map<Object, Object>> getter;
    private final Setter<T, Map<Object, Object>> setter;
    private final SchemaEx<Map.Entry<Object, Object>> entrySchema;

    public MapSchema(Field protoField, PropertyDescriptor propertyDescriptor, SchemaEx<Map.Entry<Object, Object>> entrySchema) {
        super(protoField, propertyDescriptor.getJavaType());
        this.entrySchema = new MapEntrySchema(entrySchema);
        this.getter = (Getter)propertyDescriptor.getGetter();
        this.setter = (Setter)propertyDescriptor.getSetter();
    }

    @Override
    public final int mergeFrom(InputEx input, T message) throws IOException {
        int fieldNumber;
        LinkedHashMap map = (LinkedHashMap)this.getter.get(message);
        if (map == null) {
            map = new LinkedHashMap();
            this.setter.set(message, map);
        }
        MapEntry entry = new MapEntry();
        do {
            input.mergeObject(entry, this.entrySchema);
            map.put(entry.getKey(), entry.getValue());
            entry.setValue(null);
        } while ((fieldNumber = input.readFieldNumber()) == this.fieldNumber);
        return fieldNumber;
    }

    @Override
    public final void getAndWriteTo(OutputEx output, T message) throws IOException {
        Map map = (Map)this.getter.get(message);
        if (map == null) {
            return;
        }
        this.writeMap(output, map);
    }

    @Override
    public final void writeTo(OutputEx output, Object value) throws IOException {
        this.writeMap(output, (Map)value);
    }

    private void writeMap(OutputEx output, Map<Object, Object> map) throws IOException {
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            output.writeObject(this.tag, this.tagSize, entry, this.entrySchema);
        }
    }
}

