/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.consumer;

import java.util.Collection;
import java.util.List;
import org.apache.servicecomb.foundation.common.VendorExtensions;
import org.apache.servicecomb.foundation.common.Version;
import org.apache.servicecomb.registry.DiscoveryManager;
import org.apache.servicecomb.registry.api.event.CreateMicroserviceVersionEvent;
import org.apache.servicecomb.registry.api.event.DestroyMicroserviceVersionEvent;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.consumer.AppManager;
import org.apache.servicecomb.registry.consumer.MicroserviceVersions;

public class MicroserviceVersion {
    protected AppManager appManager;
    protected MicroserviceVersions microserviceVersions;
    protected String microserviceName;
    protected Version version;
    protected Microservice microservice;
    protected Collection<MicroserviceInstance> instances;
    private final VendorExtensions vendorExtensions = new VendorExtensions();

    public MicroserviceVersion(MicroserviceVersions microserviceVersions, String microserviceId, String microserviceName, Collection<MicroserviceInstance> instances) {
        Microservice microservice = DiscoveryManager.INSTANCE.getMicroservice(microserviceId);
        if (microservice == null) {
            throw new IllegalStateException(String.format("failed to query by microserviceId '%s' from ServiceCenter.", microserviceId));
        }
        this.init(microserviceVersions, microservice, microserviceName, instances);
        this.appManager.getEventBus().post((Object)new CreateMicroserviceVersionEvent(this));
    }

    public MicroserviceVersion(MicroserviceVersions microserviceVersions, Microservice microservice, String microserviceName, Collection<MicroserviceInstance> instances) {
        this.init(microserviceVersions, microservice, microserviceName, instances);
        this.appManager.getEventBus().post((Object)new CreateMicroserviceVersionEvent(this));
    }

    protected void init(MicroserviceVersions microserviceVersions, Microservice microservice, String microserviceName, Collection<MicroserviceInstance> instances) {
        this.appManager = microserviceVersions.getAppManager();
        this.microserviceVersions = microserviceVersions;
        this.microservice = microservice;
        this.microserviceName = microserviceName;
        this.instances = instances;
        this.version = new Version(microservice.getVersion());
    }

    public MicroserviceVersions getMicroserviceVersions() {
        return this.microserviceVersions;
    }

    public Collection<MicroserviceInstance> getInstances() {
        return this.instances;
    }

    public void setInstances(List<MicroserviceInstance> instances) {
        this.instances = instances;
    }

    public String getMicroserviceName() {
        return this.microserviceName;
    }

    public String getMicroserviceId() {
        return this.microservice.getServiceId();
    }

    public Microservice getMicroservice() {
        return this.microservice;
    }

    public Version getVersion() {
        return this.version;
    }

    public VendorExtensions getVendorExtensions() {
        return this.vendorExtensions;
    }

    public void destroy() {
        this.appManager.getEventBus().post((Object)new DestroyMicroserviceVersionEvent(this));
    }
}

