/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.discovery;

import com.netflix.config.DynamicPropertyFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstanceStatus;
import org.apache.servicecomb.registry.discovery.AbstractDiscoveryFilter;
import org.apache.servicecomb.registry.discovery.DiscoveryContext;
import org.apache.servicecomb.registry.discovery.DiscoveryTreeNode;

public class InstanceStatusDiscoveryFilter
extends AbstractDiscoveryFilter {
    private static final String UP_INSTANCES = "upInstances";

    @Override
    public int getOrder() {
        return -10000;
    }

    @Override
    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.loadbalance.filter.status.enabled", true).get();
    }

    @Override
    public boolean isGroupingFilter() {
        return true;
    }

    @Override
    protected String findChildName(DiscoveryContext context, DiscoveryTreeNode parent) {
        return UP_INSTANCES;
    }

    @Override
    public void init(DiscoveryContext context, DiscoveryTreeNode parent) {
        Map instances = (Map)parent.data();
        HashMap filteredServers = new HashMap();
        for (Map.Entry instanceEntry : instances.entrySet()) {
            MicroserviceInstance instance = (MicroserviceInstance)instanceEntry.getValue();
            if (MicroserviceInstanceStatus.UP != instance.getStatus()) continue;
            filteredServers.put(instanceEntry.getKey(), instance);
        }
        if (filteredServers.isEmpty()) {
            return;
        }
        DiscoveryTreeNode child = (DiscoveryTreeNode)new DiscoveryTreeNode().subName(parent, UP_INSTANCES).data(filteredServers);
        parent.child(UP_INSTANCES, child);
    }
}

