/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.jdbc;

import org.springframework.data.jdbc.core.dialect.JdbcDb2Dialect;
import org.springframework.data.jdbc.core.dialect.JdbcPostgresDialect;
import org.springframework.data.jdbc.core.dialect.JdbcSqlServerDialect;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.dialect.H2Dialect;
import org.springframework.data.relational.core.dialect.HsqlDbDialect;
import org.springframework.data.relational.core.dialect.MySqlDialect;
import org.springframework.data.relational.core.dialect.OracleDialect;

public enum JdbcDatabaseDialect {
    DB2((Dialect)JdbcDb2Dialect.INSTANCE),
    H2((Dialect)H2Dialect.INSTANCE),
    HSQL((Dialect)HsqlDbDialect.INSTANCE),
    MARIA((Dialect)MySqlDialect.INSTANCE),
    MYSQL((Dialect)MySqlDialect.INSTANCE),
    ORACLE((Dialect)OracleDialect.INSTANCE),
    POSTGRESQL((Dialect)JdbcPostgresDialect.INSTANCE),
    SQL_SERVER((Dialect)JdbcSqlServerDialect.INSTANCE);

    private final Dialect dialect;

    private JdbcDatabaseDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    final Dialect getDialect() {
        return this.dialect;
    }
}

