/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.spi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.spi.ExtensionFactory;
import org.apache.shenyu.spi.Join;
import org.apache.shenyu.spi.SPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtensionLoader<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionLoader.class);
    private static final String SHENYU_DIRECTORY = "META-INF/shenyu/";
    private static final Map<Class<?>, ExtensionLoader<?>> LOADERS = new ConcurrentHashMap();
    private static final Comparator<Holder<Object>> HOLDER_COMPARATOR = Comparator.comparing(Holder::getOrder);
    private static final Comparator<ClassEntity> CLASS_ENTITY_COMPARATOR = Comparator.comparing(ClassEntity::getOrder);
    private final Class<T> clazz;
    private final ClassLoader classLoader;
    private final Holder<Map<String, ClassEntity>> cachedClasses = new Holder();
    private final Map<String, Holder<Object>> cachedInstances = new ConcurrentHashMap<String, Holder<Object>>();
    private final Map<Class<?>, Object> joinInstances = new ConcurrentHashMap();
    private String cachedDefaultName;

    private ExtensionLoader(Class<T> clazz, ClassLoader cl) {
        this.clazz = clazz;
        this.classLoader = cl;
        if (!Objects.equals(clazz, ExtensionFactory.class)) {
            ExtensionLoader.getExtensionLoader(ExtensionFactory.class).getExtensionClassesEntity();
        }
    }

    public static <T> ExtensionLoader<T> getExtensionLoader(Class<T> clazz, ClassLoader cl) {
        Objects.requireNonNull(clazz, "extension clazz is null");
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("extension clazz (" + clazz + ") is not interface!");
        }
        if (!clazz.isAnnotationPresent(SPI.class)) {
            throw new IllegalArgumentException("extension clazz (" + clazz + ") without @" + SPI.class + " Annotation");
        }
        ExtensionLoader<?> extensionLoader = LOADERS.get(clazz);
        if (Objects.nonNull(extensionLoader)) {
            return extensionLoader;
        }
        LOADERS.putIfAbsent(clazz, new ExtensionLoader<T>(clazz, cl));
        return LOADERS.get(clazz);
    }

    public static <T> ExtensionLoader<T> getExtensionLoader(Class<T> clazz) {
        return ExtensionLoader.getExtensionLoader(clazz, ExtensionLoader.class.getClassLoader());
    }

    public T getDefaultJoin() {
        this.getExtensionClassesEntity();
        if (StringUtils.isBlank((CharSequence)this.cachedDefaultName)) {
            return null;
        }
        return this.getJoin(this.cachedDefaultName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getJoin(String name) {
        Object value;
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new NullPointerException("get join name is null");
        }
        ClassEntity classEntity = this.getExtensionClassesEntity().get(name);
        if (Objects.isNull(classEntity)) {
            throw new IllegalArgumentException(name + " name is error");
        }
        if (!classEntity.isSingleton().booleanValue()) {
            return (T)this.createExtension(classEntity);
        }
        Holder<Object> objectHolder = this.cachedInstances.get(name);
        if (Objects.isNull(objectHolder)) {
            this.cachedInstances.putIfAbsent(name, new Holder());
            objectHolder = this.cachedInstances.get(name);
        }
        if (Objects.isNull(value = objectHolder.getValue())) {
            Holder<Object> holder = objectHolder;
            synchronized (holder) {
                value = objectHolder.getValue();
                if (Objects.isNull(value)) {
                    this.createExtension(name, objectHolder);
                    value = objectHolder.getValue();
                }
            }
        }
        return (T)value;
    }

    public List<T> getJoins() {
        Map<String, ClassEntity> extensionClassesEntity = this.getExtensionClassesEntity();
        if (extensionClassesEntity.isEmpty()) {
            return Collections.emptyList();
        }
        if (Objects.equals(extensionClassesEntity.size(), this.cachedInstances.size())) {
            return this.cachedInstances.values().stream().sorted(HOLDER_COMPARATOR).map(e -> e.getValue()).collect(Collectors.toList());
        }
        ArrayList joins = new ArrayList();
        List<ClassEntity> classEntities = extensionClassesEntity.values().stream().sorted(CLASS_ENTITY_COMPARATOR).collect(Collectors.toList());
        classEntities.forEach(v -> {
            T join = this.getJoin(v.getName());
            joins.add(join);
        });
        return joins;
    }

    private Object createExtension(ClassEntity classEntity) {
        Class<?> aClass = classEntity.getClazz();
        try {
            return aClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Extension instance(name: " + classEntity.getName() + ", class: " + aClass + ")  could not be instantiated: " + e.getMessage(), e);
        }
    }

    private void createExtension(String name, Holder<Object> holder) {
        ClassEntity classEntity = this.getExtensionClassesEntity().get(name);
        if (Objects.isNull(classEntity)) {
            throw new IllegalArgumentException(name + " name is error");
        }
        Class<?> aClass = classEntity.getClazz();
        Object o = this.joinInstances.get(aClass);
        if (Objects.isNull(o)) {
            o = this.createExtension(classEntity);
            if (classEntity.isSingleton().booleanValue()) {
                this.joinInstances.putIfAbsent(aClass, o);
                o = this.joinInstances.get(aClass);
            }
        }
        holder.setOrder(classEntity.getOrder());
        holder.setValue(o);
    }

    public Map<String, Class<?>> getExtensionClasses1() {
        Map<String, ClassEntity> classes = this.getExtensionClassesEntity();
        return classes.values().stream().collect(Collectors.toMap(e -> e.getName(), x -> x.getClazz(), (a, b) -> a));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ClassEntity> getExtensionClassesEntity() {
        Map<String, ClassEntity> classes = this.cachedClasses.getValue();
        if (Objects.isNull(classes)) {
            Holder<Map<String, ClassEntity>> holder = this.cachedClasses;
            synchronized (holder) {
                classes = this.cachedClasses.getValue();
                if (Objects.isNull(classes)) {
                    classes = this.loadExtensionClass();
                    this.cachedClasses.setValue(classes);
                    this.cachedClasses.setOrder(0);
                }
            }
        }
        return classes;
    }

    private Map<String, ClassEntity> loadExtensionClass() {
        String value;
        SPI annotation = this.clazz.getAnnotation(SPI.class);
        if (Objects.nonNull(annotation) && StringUtils.isNotBlank((CharSequence)(value = annotation.value()))) {
            this.cachedDefaultName = value;
        }
        HashMap<String, ClassEntity> classes = new HashMap<String, ClassEntity>(16);
        this.loadDirectory(classes);
        return classes;
    }

    private void loadDirectory(Map<String, ClassEntity> classes) {
        String fileName = SHENYU_DIRECTORY + this.clazz.getName();
        try {
            Enumeration<URL> urls;
            Enumeration<URL> enumeration = urls = Objects.nonNull(this.classLoader) ? this.classLoader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
            if (Objects.nonNull(urls)) {
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    this.loadResources(classes, url);
                }
            }
        }
        catch (IOException t) {
            LOG.error("load extension class error {}", (Object)fileName, (Object)t);
        }
    }

    private void loadResources(Map<String, ClassEntity> classes, URL url) throws IOException {
        try (InputStream inputStream = url.openStream();){
            Properties properties = new Properties();
            properties.load(inputStream);
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String name = (String)k;
                String classPath = (String)v;
                if (StringUtils.isNotBlank((CharSequence)name) && StringUtils.isNotBlank((CharSequence)classPath)) {
                    try {
                        this.loadClass(classes, name, classPath);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("load extension resources error", e);
                    }
                }
            }));
        }
        catch (IOException e) {
            throw new IllegalStateException("load extension resources error", e);
        }
    }

    private void loadClass(Map<String, ClassEntity> classes, String name, String classPath) throws ClassNotFoundException {
        Class<?> subClass;
        Class<?> clazz = subClass = Objects.nonNull(this.classLoader) ? Class.forName(classPath, true, this.classLoader) : Class.forName(classPath);
        if (!this.clazz.isAssignableFrom(subClass)) {
            throw new IllegalStateException("load extension resources error," + subClass + " subtype is not of " + this.clazz);
        }
        if (!subClass.isAnnotationPresent(Join.class)) {
            throw new IllegalStateException("load extension resources error," + subClass + " without @" + Join.class + " annotation");
        }
        ClassEntity oldClassEntity = classes.get(name);
        if (Objects.isNull(oldClassEntity)) {
            Join joinAnnotation = subClass.getAnnotation(Join.class);
            ClassEntity classEntity = new ClassEntity(name, joinAnnotation.order(), subClass, joinAnnotation.isSingleton());
            classes.put(name, classEntity);
        } else if (!Objects.equals(oldClassEntity.getClazz(), subClass)) {
            throw new IllegalStateException("load extension resources error,Duplicate class " + this.clazz.getName() + " name " + name + " on " + oldClassEntity.getClazz().getName() + " or " + subClass.getName());
        }
    }

    private static final class Holder<T> {
        private volatile T value;
        private Integer order;

        private Holder() {
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public void setOrder(Integer order) {
            this.order = order;
        }

        public Integer getOrder() {
            return this.order;
        }
    }

    private static final class ClassEntity {
        private String name;
        private Integer order;
        private Boolean isSingleton;
        private Class<?> clazz;

        private ClassEntity(String name, Integer order, Class<?> clazz, boolean isSingleton) {
            this.name = name;
            this.order = order;
            this.clazz = clazz;
            this.isSingleton = isSingleton;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public void setClazz(Class<?> clazz) {
            this.clazz = clazz;
        }

        public String getName() {
            return this.name;
        }

        public Integer getOrder() {
            return this.order;
        }

        public Boolean isSingleton() {
            return this.isSingleton;
        }
    }
}

