/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.integration.annotation.Aggregator;
import org.springframework.integration.annotation.BridgeFrom;
import org.springframework.integration.annotation.BridgeTo;
import org.springframework.integration.annotation.Filter;
import org.springframework.integration.annotation.InboundChannelAdapter;
import org.springframework.integration.annotation.Router;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.annotation.Splitter;
import org.springframework.integration.annotation.Transformer;
import org.springframework.integration.config.AggregatorAnnotationPostProcessor;
import org.springframework.integration.config.BridgeFromAnnotationPostProcessor;
import org.springframework.integration.config.BridgeToAnnotationPostProcessor;
import org.springframework.integration.config.FilterAnnotationPostProcessor;
import org.springframework.integration.config.InboundChannelAdapterAnnotationPostProcessor;
import org.springframework.integration.config.MessagingAnnotationBeanPostProcessor;
import org.springframework.integration.config.RouterAnnotationPostProcessor;
import org.springframework.integration.config.ServiceActivatorAnnotationPostProcessor;
import org.springframework.integration.config.SplitterAnnotationPostProcessor;
import org.springframework.integration.config.TransformerAnnotationPostProcessor;
import org.springframework.integration.config.annotation.MethodAnnotationPostProcessor;
import org.springframework.integration.util.MessagingAnnotationUtils;
import org.springframework.util.CollectionUtils;

public class MessagingAnnotationPostProcessor
implements BeanDefinitionRegistryPostProcessor {
    private final Map<Class<? extends Annotation>, MethodAnnotationPostProcessor<?>> postProcessors = new HashMap();
    private BeanDefinitionRegistry registry;
    private ConfigurableListableBeanFactory beanFactory;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        String[] beanNames;
        this.registry = registry;
        this.postProcessors.put(Filter.class, new FilterAnnotationPostProcessor());
        this.postProcessors.put(Router.class, new RouterAnnotationPostProcessor());
        this.postProcessors.put(Transformer.class, new TransformerAnnotationPostProcessor());
        this.postProcessors.put(ServiceActivator.class, new ServiceActivatorAnnotationPostProcessor());
        this.postProcessors.put(Splitter.class, new SplitterAnnotationPostProcessor());
        this.postProcessors.put(Aggregator.class, new AggregatorAnnotationPostProcessor());
        this.postProcessors.put(InboundChannelAdapter.class, new InboundChannelAdapterAnnotationPostProcessor());
        this.postProcessors.put(BridgeFrom.class, new BridgeFromAnnotationPostProcessor());
        this.postProcessors.put(BridgeTo.class, new BridgeToAnnotationPostProcessor());
        Map<Class<? extends Annotation>, MethodAnnotationPostProcessor<?>> customPostProcessors = this.setupCustomPostProcessors();
        if (!CollectionUtils.isEmpty(customPostProcessors)) {
            this.postProcessors.putAll(customPostProcessors);
        }
        this.postProcessors.values().stream().filter(BeanFactoryAware.class::isInstance).map(BeanFactoryAware.class::cast).forEach(processor -> processor.setBeanFactory((BeanFactory)this.registry));
        for (String beanName : beanNames = registry.getBeanDefinitionNames()) {
            AnnotatedBeanDefinition annotatedBeanDefinition;
            BeanDefinition beanDef = registry.getBeanDefinition(beanName);
            if (!(beanDef instanceof AnnotatedBeanDefinition) || (annotatedBeanDefinition = (AnnotatedBeanDefinition)beanDef).getFactoryMethodMetadata() == null) continue;
            this.processCandidate(beanName, annotatedBeanDefinition);
        }
    }

    public MessagingAnnotationBeanPostProcessor messagingAnnotationBeanPostProcessor() {
        return new MessagingAnnotationBeanPostProcessor(this.postProcessors);
    }

    private void processCandidate(String beanName, AnnotatedBeanDefinition beanDefinition) {
        MethodMetadata methodMetadata = beanDefinition.getFactoryMethodMetadata();
        MergedAnnotations annotations = methodMetadata.getAnnotations();
        if (methodMetadata instanceof StandardMethodMetadata) {
            StandardMethodMetadata standardMethodMetadata = (StandardMethodMetadata)methodMetadata;
            annotations = MergedAnnotations.from((AnnotatedElement)standardMethodMetadata.getIntrospectedMethod());
        }
        List<MessagingAnnotationBeanPostProcessor.MessagingMetaAnnotation> messagingAnnotations = MessagingAnnotationBeanPostProcessor.obtainMessagingAnnotations(this.postProcessors.keySet(), annotations, beanName);
        for (MessagingAnnotationBeanPostProcessor.MessagingMetaAnnotation messagingAnnotation : messagingAnnotations) {
            Class<? extends Annotation> annotationType = messagingAnnotation.annotationType();
            List<Annotation> annotationChain = MessagingAnnotationUtils.getAnnotationChain(messagingAnnotation.annotation(), annotationType);
            this.processMessagingAnnotationOnBean(beanName, beanDefinition, annotationType, annotationChain);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processMessagingAnnotationOnBean(String beanName, AnnotatedBeanDefinition beanDefinition, Class<? extends Annotation> annotationType, List<Annotation> annotationChain) {
        MethodAnnotationPostProcessor<?> messagingAnnotationProcessor = this.postProcessors.get(annotationType);
        if (messagingAnnotationProcessor == null) return;
        if (!messagingAnnotationProcessor.beanAnnotationAware()) throw new BeanDefinitionValidationException("The messaging annotation '" + annotationType + "' cannot be declared on '@Bean'. The bean definition with the problem is: " + beanName);
        if (!messagingAnnotationProcessor.shouldCreateEndpoint(beanDefinition.getFactoryMethodMetadata().getAnnotations(), annotationChain)) throw new BeanDefinitionValidationException("The input channel for endpoint on '@Bean' method must be set for the " + annotationType + ". The bean definition with the problem is: " + beanName);
        messagingAnnotationProcessor.processBeanDefinition(beanName, beanDefinition, annotationChain);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected ConfigurableListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected BeanDefinitionRegistry getBeanDefinitionRegistry() {
        return this.registry;
    }

    protected Map<Class<? extends Annotation>, MethodAnnotationPostProcessor<?>> setupCustomPostProcessors() {
        return null;
    }

    public <A extends Annotation> void addMessagingAnnotationPostProcessor(Class<A> annotation, MethodAnnotationPostProcessor<A> postProcessor) {
        this.postProcessors.put(annotation, postProcessor);
    }

    protected Map<Class<? extends Annotation>, MethodAnnotationPostProcessor<?>> getPostProcessors() {
        return this.postProcessors;
    }
}

