/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.registry.zookeeper;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.registry.api.ShenyuInstanceRegisterRepository;
import org.apache.shenyu.registry.api.config.RegisterConfig;
import org.apache.shenyu.registry.api.entity.InstanceEntity;
import org.apache.shenyu.registry.api.event.ChangedEventListener;
import org.apache.shenyu.registry.api.path.InstancePathConstants;
import org.apache.shenyu.registry.zookeeper.ZookeeperClient;
import org.apache.shenyu.registry.zookeeper.ZookeeperConfig;
import org.apache.shenyu.spi.Join;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join(isSingleton=false)
public class ZookeeperInstanceRegisterRepository
implements ShenyuInstanceRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperInstanceRegisterRepository.class);
    private ZookeeperClient client;
    private String watchPath;
    private final Map<String, String> nodeDataMap = new HashMap<String, String>();
    private final Multimap<String, CuratorCache> cacheMap = ArrayListMultimap.create();
    private final Map<String, List<InstanceEntity>> watcherInstanceRegisterMap = new HashMap<String, List<InstanceEntity>>();

    public void init(RegisterConfig config) {
        Properties props = config.getProps();
        int sessionTimeout = Integer.parseInt(props.getProperty("sessionTimeout", "3000"));
        int connectionTimeout = Integer.parseInt(props.getProperty("connectionTimeout", "3000"));
        int baseSleepTime = Integer.parseInt(props.getProperty("baseSleepTime", "1000"));
        int maxRetries = Integer.parseInt(props.getProperty("maxRetries", "3"));
        int maxSleepTime = Integer.parseInt(props.getProperty("maxSleepTime", String.valueOf(Integer.MAX_VALUE)));
        this.watchPath = props.getProperty("watchPath", null);
        ZookeeperConfig zkConfig = new ZookeeperConfig(config.getServerLists());
        zkConfig.setBaseSleepTimeMilliseconds(baseSleepTime).setMaxRetries(maxRetries).setMaxSleepTimeMilliseconds(maxSleepTime).setSessionTimeoutMilliseconds(sessionTimeout).setConnectionTimeoutMilliseconds(connectionTimeout);
        String digest = props.getProperty("digest");
        if (!StringUtils.isEmpty((CharSequence)digest)) {
            zkConfig.setDigest(digest);
        }
        this.client = new ZookeeperClient(zkConfig);
        this.client.getClient().getConnectionStateListenable().addListener((c, newState) -> {
            if (newState == ConnectionState.RECONNECTED) {
                this.nodeDataMap.forEach((k, v) -> {
                    if (!this.client.isExist((String)k)) {
                        this.client.createOrUpdate((String)k, (String)v, CreateMode.EPHEMERAL);
                        LOGGER.info("zookeeper registry client register instance success: {}", v);
                    }
                });
            }
        });
        LOGGER.info("zookeeper registry init...");
        this.client.start();
    }

    public void persistInstance(InstanceEntity instance) {
        String uriNodeName = this.buildInstanceNodeName(instance);
        String instancePath = InstancePathConstants.buildInstanceParentPath((String)instance.getAppName());
        if (!this.client.isExist(instancePath)) {
            this.client.createOrUpdate(instancePath, "", CreateMode.PERSISTENT);
        }
        String realNode = InstancePathConstants.buildRealNode((String)instancePath, (String)uriNodeName);
        String nodeData = GsonUtils.getInstance().toJson((Object)instance);
        this.nodeDataMap.put(realNode, nodeData);
        this.client.createOrUpdate(realNode, nodeData, CreateMode.EPHEMERAL);
        LOGGER.info("zookeeper registry persistInstance success: {}", (Object)nodeData);
    }

    public List<InstanceEntity> selectInstances(final String selectKey) {
        try {
            String watchKey = StringUtils.isNotBlank((CharSequence)this.watchPath) ? InstancePathConstants.buildRealNode((String)this.watchPath, (String)selectKey) : InstancePathConstants.buildInstanceParentPath((String)selectKey);
            final Function<List, List> getInstanceRegisterFun = childrenList -> childrenList.stream().map(childPath -> {
                String instanceRegisterJsonStr = this.client.get(InstancePathConstants.buildRealNode((String)watchKey, (String)childPath));
                InstanceEntity instanceEntity = (InstanceEntity)GsonUtils.getInstance().fromJson(instanceRegisterJsonStr, InstanceEntity.class);
                instanceEntity.setUri(this.getURI(instanceRegisterJsonStr, instanceEntity.getPort(), instanceEntity.getHost()));
                if (Objects.isNull(instanceEntity.getUri())) {
                    JsonObject hashMap = (JsonObject)GsonUtils.getInstance().fromJson(instanceRegisterJsonStr, JsonObject.class);
                    String address = hashMap.get("address").getAsString();
                    Integer port = hashMap.get("port").getAsInt();
                    instanceEntity.setUri(this.getURI(instanceRegisterJsonStr, port, address));
                }
                return instanceEntity;
            }).collect(Collectors.toList());
            if (this.watcherInstanceRegisterMap.containsKey(selectKey)) {
                return this.watcherInstanceRegisterMap.get(selectKey);
            }
            List<String> childrenPathList = this.client.subscribeChildrenChanges(watchKey, new CuratorWatcher(){

                public void process(WatchedEvent event) {
                    try {
                        List childrenList;
                        String path = Objects.isNull(event.getPath()) ? selectKey : event.getPath();
                        List<Object> list = childrenList = StringUtils.isNotBlank((CharSequence)path) ? ZookeeperInstanceRegisterRepository.this.client.subscribeChildrenChanges(path, this) : Collections.emptyList();
                        if (!childrenList.isEmpty()) {
                            ZookeeperInstanceRegisterRepository.this.watcherInstanceRegisterMap.put(selectKey, (List)getInstanceRegisterFun.apply(childrenList));
                        }
                    }
                    catch (Exception e) {
                        ZookeeperInstanceRegisterRepository.this.watcherInstanceRegisterMap.remove(selectKey);
                        LOGGER.error("zookeeper registry client subscribeChildrenChanges watch interrupt error:", (Throwable)e);
                    }
                }
            });
            List instanceEntities = getInstanceRegisterFun.apply(childrenPathList);
            this.watcherInstanceRegisterMap.put(selectKey, instanceEntities);
            return instanceEntities;
        }
        catch (Exception e) {
            LOGGER.error("zookeeper registry client selectInstances error:", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public boolean serviceExists(String key) {
        try {
            return Objects.nonNull(this.client.get(key));
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public void watchInstances(String key, ChangedEventListener listener) {
        try {
            CuratorCache treeCache = this.client.addCache(key, (type, oldData, data) -> {
                boolean isEphemeral;
                if (!Objects.nonNull(data) || !Objects.nonNull(data.getData())) {
                    return;
                }
                String currentPath = data.getPath();
                String currentData = new String(data.getData(), StandardCharsets.UTF_8);
                LOGGER.info("zookeeper registry watch find resultData ={}", (Object)currentData);
                Stat stat = data.getStat();
                boolean bl = isEphemeral = Objects.nonNull(stat) && stat.getEphemeralOwner() > 0L;
                if (!isEphemeral) {
                    LOGGER.info("zookeeper registry watch Ignore non-ephemeral node changes path {}", (Object)currentPath);
                    return;
                }
                switch (type) {
                    case NODE_CREATED: {
                        listener.onEvent(currentPath, currentData, ChangedEventListener.Event.ADDED);
                        break;
                    }
                    case NODE_CHANGED: {
                        listener.onEvent(currentPath, currentData, ChangedEventListener.Event.UPDATED);
                        break;
                    }
                    case NODE_DELETED: {
                        listener.onEvent(currentPath, currentData, ChangedEventListener.Event.DELETED);
                        break;
                    }
                    default: {
                        listener.onEvent(currentPath, currentData, ChangedEventListener.Event.IGNORED);
                    }
                }
            });
            this.cacheMap.put((Object)key, (Object)treeCache);
            LOGGER.info("zookeeper registry subscribed to eureka updates for key: {}", (Object)key);
        }
        catch (Exception e) {
            LOGGER.error("zookeeper registry error watching key: {}", (Object)key, (Object)e);
            throw new ShenyuException((Throwable)e);
        }
    }

    public void unWatchInstances(String key) {
        if (this.cacheMap.containsKey((Object)key)) {
            this.cacheMap.get((Object)key).forEach(CuratorCache::close);
            this.cacheMap.removeAll((Object)key);
        }
    }

    private URI getURI(String instanceRegisterJsonStr, Integer port, String host) {
        if (Objects.isNull(port) || Objects.isNull(host)) {
            return null;
        }
        String scheme = instanceRegisterJsonStr.contains("https") || instanceRegisterJsonStr.contains("HTTPS") ? "https" : "http";
        String uri = String.format("%s://%s:%s", scheme, host, port);
        return URI.create(uri);
    }

    public void close() {
        try {
            this.watcherInstanceRegisterMap.clear();
            this.cacheMap.values().forEach(CuratorCache::close);
            this.client.close();
            this.client = null;
            LOGGER.info("zookeeper registry shutting down...");
        }
        catch (Exception e) {
            LOGGER.error("zookeeper registry shutting down error", (Throwable)e);
            throw new ShenyuException((Throwable)e);
        }
    }

    private String buildInstanceNodeName(InstanceEntity instance) {
        String host = instance.getHost();
        int port = instance.getPort();
        return String.join((CharSequence)":", host, Integer.toString(port));
    }
}

