/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.DoubleCounter;
import com.netflix.servo.monitor.MaxGauge;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.NumericMonitor;
import com.netflix.servo.monitor.StepCounter;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.TimedStopwatch;
import com.netflix.servo.monitor.Timer;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.Tags;
import com.netflix.servo.util.Clock;
import com.netflix.servo.util.ClockWithOffset;
import com.netflix.servo.util.UnmodifiableList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class BasicTimer
extends AbstractMonitor<Long>
implements Timer,
CompositeMonitor<Long> {
    private static final String STATISTIC = "statistic";
    private static final String UNIT = "unit";
    private static final Tag STAT_TOTAL = Tags.newTag("statistic", "totalTime");
    private static final Tag STAT_COUNT = Tags.newTag("statistic", "count");
    private static final Tag STAT_TOTAL_SQ = Tags.newTag("statistic", "totalOfSquares");
    private static final Tag STAT_MAX = Tags.newTag("statistic", "max");
    private final TimeUnit timeUnit;
    private final double timeUnitNanosFactor;
    private final StepCounter totalTime;
    private final StepCounter count;
    private final DoubleCounter totalOfSquares;
    private final MaxGauge max;
    private final List<Monitor<?>> monitors;

    public BasicTimer(MonitorConfig config) {
        this(config, TimeUnit.MILLISECONDS);
    }

    BasicTimer(MonitorConfig config, TimeUnit unit, Clock clock) {
        super(config);
        Tag unitTag = Tags.newTag(UNIT, unit.name());
        MonitorConfig unitConfig = config.withAdditionalTag(unitTag);
        this.timeUnit = unit;
        this.timeUnitNanosFactor = 1.0 / (double)this.timeUnit.toNanos(1L);
        this.totalTime = new StepCounter(unitConfig.withAdditionalTag(STAT_TOTAL), clock);
        this.count = new StepCounter(unitConfig.withAdditionalTag(STAT_COUNT), clock);
        this.totalOfSquares = new DoubleCounter(unitConfig.withAdditionalTag(STAT_TOTAL_SQ), clock);
        this.max = new MaxGauge(unitConfig.withAdditionalTag(STAT_MAX), clock);
        FactorMonitor<Number> totalTimeFactor = new FactorMonitor<Number>(this.totalTime, this.timeUnitNanosFactor);
        FactorMonitor<Number> totalSquaresFactor = new FactorMonitor<Number>(this.totalOfSquares, this.timeUnitNanosFactor * this.timeUnitNanosFactor);
        FactorMonitor<Long> maxFactor = new FactorMonitor<Long>(this.max, this.timeUnitNanosFactor);
        this.monitors = UnmodifiableList.of(totalTimeFactor, this.count, totalSquaresFactor, maxFactor);
    }

    public BasicTimer(MonitorConfig config, TimeUnit unit) {
        this(config, unit, ClockWithOffset.INSTANCE);
    }

    @Override
    public List<Monitor<?>> getMonitors() {
        return this.monitors;
    }

    @Override
    public Stopwatch start() {
        TimedStopwatch s = new TimedStopwatch(this);
        s.start();
        return s;
    }

    @Override
    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    private void recordNanos(long nanos) {
        if (nanos >= 0L) {
            this.totalTime.increment(nanos);
            this.count.increment();
            this.totalOfSquares.increment((double)nanos * (double)nanos);
            this.max.update(nanos);
        }
    }

    @Override
    @Deprecated
    public void record(long duration) {
        long nanos = this.timeUnit.toNanos(duration);
        this.recordNanos(nanos);
    }

    @Override
    public void record(long duration, TimeUnit unit) {
        this.recordNanos(unit.toNanos(duration));
    }

    private double getTotal(int pollerIndex) {
        return (double)this.totalTime.getCurrentCount(pollerIndex) * this.timeUnitNanosFactor;
    }

    @Override
    public Long getValue(int pollerIndex) {
        long cnt = this.count.getCurrentCount(pollerIndex);
        long value = (long)(this.getTotal(pollerIndex) / (double)cnt);
        return cnt == 0L ? 0L : value;
    }

    public Double getTotalTime() {
        return this.getTotal(0);
    }

    public Long getCount() {
        return this.count.getCurrentCount(0);
    }

    public Double getMax() {
        return (double)this.max.getCurrentValue(0) * this.timeUnitNanosFactor;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof BasicTimer)) {
            return false;
        }
        BasicTimer m = (BasicTimer)obj;
        return this.config.equals(m.getConfig()) && this.totalTime.equals(m.totalTime) && this.count.equals(m.count) && this.totalOfSquares.equals(m.totalOfSquares) && this.max.equals(m.max);
    }

    public int hashCode() {
        int result = this.config.hashCode();
        result = 31 * result + this.totalTime.hashCode();
        result = 31 * result + this.count.hashCode();
        result = 31 * result + this.totalOfSquares.hashCode();
        result = 31 * result + this.max.hashCode();
        return result;
    }

    public String toString() {
        return "BasicTimer{config=" + this.config + ", totalTime=" + this.totalTime + ", count=" + this.count + ", totalOfSquares=" + this.totalOfSquares + ", max=" + this.max + '}';
    }

    private static final class FactorMonitor<T extends Number>
    extends AbstractMonitor<Double>
    implements NumericMonitor<Double> {
        private final Monitor<T> wrapped;
        private final double factor;

        FactorMonitor(Monitor<T> wrapped, double factor) {
            super(wrapped.getConfig());
            this.wrapped = wrapped;
            this.factor = factor;
        }

        @Override
        public Double getValue(int pollerIndex) {
            return ((Number)this.wrapped.getValue(pollerIndex)).doubleValue() * this.factor;
        }
    }
}

