/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.event.user;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.DashboardUserDO;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.apache.shenyu.admin.model.event.BatchChangedEvent;
import org.apache.shenyu.common.utils.ListUtil;

public class BatchUserDeletedEvent
extends BatchChangedEvent {
    private final List<String> deletedIds;

    public BatchUserDeletedEvent(Collection<DashboardUserDO> source, String operator) {
        super(source, null, EventTypeEnum.USER_DELETE, operator);
        this.deletedIds = ListUtil.map(source, BaseDO::getId);
    }

    @Override
    public String buildContext() {
        String selector = ((Collection)this.getSource()).stream().map(s -> ((DashboardUserDO)s).getUserName()).collect(Collectors.joining(","));
        return String.format("the user[%s] is %s", selector, StringUtils.lowerCase((String)this.getType().getType().toString()));
    }

    public List<DashboardUserDO> getUsers() {
        return ((Collection)this.getSource()).stream().map(DashboardUserDO.class::cast).collect(Collectors.toList());
    }

    public List<String> getDeletedIds() {
        return this.deletedIds;
    }
}

