/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.shiro.config;

import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.custom.UserInfo;
import org.apache.shenyu.admin.model.vo.DashboardUserVO;
import org.apache.shenyu.admin.service.DashboardUserService;
import org.apache.shenyu.admin.service.PermissionService;
import org.apache.shenyu.admin.utils.JwtUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.BearerToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.springframework.stereotype.Service;

@Service(value="shiroRealm")
public class ShiroRealm
extends AuthorizingRealm {
    private final PermissionService permissionService;
    private final DashboardUserService dashboardUserService;

    public ShiroRealm(PermissionService permissionService, DashboardUserService dashboardUserService) {
        this.permissionService = permissionService;
        this.dashboardUserService = dashboardUserService;
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof BearerToken;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        UserInfo userInfo = (UserInfo)principalCollection.getPrimaryPrincipal();
        Set<String> permissions = this.permissionService.getAuthPermByUserName(userInfo.getUserName());
        if (CollectionUtils.isEmpty(permissions)) {
            return null;
        }
        SimpleAuthorizationInfo simpleAuthorizationInfo = new SimpleAuthorizationInfo();
        simpleAuthorizationInfo.setStringPermissions(permissions);
        return simpleAuthorizationInfo;
    }

    protected boolean isPermitted(Permission permission, AuthorizationInfo info) {
        UserInfo userInfo = (UserInfo)SecurityUtils.getSubject().getPrincipal();
        if (Objects.nonNull(userInfo) && "admin".equals(userInfo.getUserName())) {
            return true;
        }
        return super.isPermitted(permission, info);
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) {
        String token = (String)authenticationToken.getCredentials();
        if (StringUtils.isEmpty((CharSequence)token)) {
            return null;
        }
        String userName = JwtUtils.getIssuer(token);
        if (StringUtils.isEmpty((CharSequence)userName)) {
            throw new AuthenticationException("userName is null");
        }
        DashboardUserVO dashboardUserVO = this.dashboardUserService.findByUserName(userName);
        if (Objects.isNull(dashboardUserVO)) {
            throw new AuthenticationException(String.format("userName(%s) can not be found.", userName));
        }
        String clientIdFromToken = JwtUtils.getClientId(token);
        if (StringUtils.isNotEmpty((CharSequence)clientIdFromToken) && StringUtils.isNotEmpty((CharSequence)dashboardUserVO.getClientId()) && !StringUtils.equals((CharSequence)dashboardUserVO.getClientId(), (CharSequence)clientIdFromToken)) {
            throw new AuthenticationException("clientId is invalid or does not match");
        }
        if (!JwtUtils.verifyToken(token, dashboardUserVO.getPassword())) {
            throw new AuthenticationException("token is error.");
        }
        return new SimpleAuthenticationInfo((Object)UserInfo.builder().userName(userName).userId(dashboardUserVO.getId()).build(), (Object)token, this.getName());
    }
}

