/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.thread;

import com.alipay.sofa.common.thread.ExecutingRunnable;
import com.alipay.sofa.common.thread.NamedThreadFactory;
import com.alipay.sofa.common.thread.SofaTracerCommandFactory;
import com.alipay.sofa.common.thread.ThreadPoolConfig;
import com.alipay.sofa.common.thread.ThreadPoolGovernor;
import com.alipay.sofa.common.thread.ThreadPoolStatistics;
import com.alipay.sofa.common.thread.log.ThreadLogger;
import com.alipay.sofa.common.thread.space.SpaceNamedThreadFactory;
import com.alipay.sofa.common.utils.StringUtil;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class SofaThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final String SIMPLE_CLASS_NAME = SofaThreadPoolExecutor.class.getSimpleName();
    private static final AtomicInteger POOL_COUNTER = new AtomicInteger(0);
    private final ThreadPoolConfig config;
    private final ThreadPoolStatistics statistics;
    private boolean sofaTracerTransmit = false;

    public SofaThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler, String threadPoolName, String spaceName, long taskTimeout, long period, TimeUnit timeUnit) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this.config = ThreadPoolConfig.newBuilder().threadPoolName(StringUtil.isEmpty(threadPoolName) ? this.createName() : threadPoolName).spaceName(spaceName).taskTimeout(taskTimeout).period(period).timeUnit(timeUnit).build();
        this.statistics = new ThreadPoolStatistics(this);
        ThreadPoolGovernor.getInstance().registerThreadPoolExecutor(this, this.config, this.statistics);
    }

    public SofaThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler, String threadPoolName, long taskTimeout, long period, TimeUnit timeUnit) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler, threadPoolName, null, taskTimeout, period, timeUnit);
    }

    public SofaThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler, String threadPoolName, String spaceName) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler, threadPoolName, spaceName, 0L, 0L, null);
    }

    public SofaThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler, String threadPoolName) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler, threadPoolName, 0L, 0L, null);
    }

    public SofaThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, String threadPoolName, String spaceName) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        this.config = ThreadPoolConfig.newBuilder().threadPoolName(StringUtil.isEmpty(threadPoolName) ? this.createName() : threadPoolName).spaceName(spaceName).build();
        this.statistics = new ThreadPoolStatistics(this);
        ThreadPoolGovernor.getInstance().registerThreadPoolExecutor(this, this.config, this.statistics);
        if (StringUtil.isNotEmpty(threadPoolName)) {
            if (StringUtil.isNotEmpty(spaceName)) {
                this.setThreadFactory(new SpaceNamedThreadFactory(threadPoolName, spaceName));
            } else {
                this.setThreadFactory(new NamedThreadFactory(threadPoolName));
            }
        }
    }

    public SofaThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, String threadPoolName) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadPoolName, null);
    }

    public SofaThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, "", null);
    }

    public SofaThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        this.setThreadFactory(threadFactory);
    }

    public SofaThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        this.setRejectedExecutionHandler(handler);
    }

    public SofaThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        this.setThreadFactory(threadFactory);
        this.setRejectedExecutionHandler(handler);
    }

    @Override
    public void execute(Runnable command) {
        ExecutingRunnable runner = this.sofaTracerTransmit ? SofaTracerCommandFactory.ofExecutingRunnable(command) : new ExecutingRunnable(command);
        runner.setEnqueueTime(System.currentTimeMillis());
        super.execute(runner);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        ExecutingRunnable executingRunnable = (ExecutingRunnable)r;
        executingRunnable.setDequeueTime(System.currentTimeMillis());
        executingRunnable.setThread(t);
        this.statistics.getExecutingTasks().put(executingRunnable, 0L);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        ExecutingRunnable executingRunnable = (ExecutingRunnable)r;
        executingRunnable.setFinishTime(System.currentTimeMillis());
        this.statistics.addTotalTaskCount();
        this.statistics.addTotalRunningTime(executingRunnable.getRunningTime());
        this.statistics.addTotalStayInQueueTime(executingRunnable.getStayInQueueTime());
        this.statistics.getExecutingTasks().remove(executingRunnable);
    }

    @Override
    protected void terminated() {
        super.terminated();
        ThreadPoolGovernor.getInstance().unregisterThreadPoolExecutor(this.getConfig());
    }

    public synchronized void startSchedule() {
        ThreadPoolGovernor.getInstance().startMonitorThreadPool(this.config.getIdentity());
    }

    public synchronized void stopSchedule() {
        ThreadPoolGovernor.getInstance().stopMonitorThreadPool(this.config.getIdentity());
    }

    public synchronized void reschedule() {
        ThreadPoolGovernor.getInstance().restartMonitorThreadPool(this.config.getIdentity());
    }

    public void updateThreadPoolName(String threadPoolName) {
        ThreadPoolGovernor.getInstance().unregisterThreadPoolExecutor(this.getConfig());
        this.config.setThreadPoolName(threadPoolName);
        ThreadPoolGovernor.getInstance().registerThreadPoolExecutor(this, this.config, this.statistics);
    }

    public void updateSpaceName(String spaceName) {
        ThreadPoolGovernor.getInstance().unregisterThreadPoolExecutor(this.getConfig());
        this.config.setSpaceName(spaceName);
        ThreadPoolGovernor.getInstance().registerThreadPoolExecutor(this, this.config, this.statistics);
    }

    public void updatePeriod(long period) {
        this.config.setPeriod(period);
        this.reschedule();
    }

    public void updateTaskTimeout(long taskTimeout) {
        this.config.setTaskTimeout(taskTimeout);
        this.config.setTaskTimeoutMilli(this.config.getTimeUnit().toMillis(taskTimeout));
        ThreadLogger.info("Updated '{}' taskTimeout to {} {}", new Object[]{this.config.getIdentity(), taskTimeout, this.config.getTimeUnit()});
    }

    public ThreadPoolConfig getConfig() {
        return this.config;
    }

    public ThreadPoolStatistics getStatistics() {
        return this.statistics;
    }

    private String createName() {
        return SIMPLE_CLASS_NAME + String.format("%08x", POOL_COUNTER.getAndIncrement());
    }

    public void setSofaTracerTransmit(boolean sofaTracerTransmit) {
        this.sofaTracerTransmit = sofaTracerTransmit;
    }

    public boolean isSofaTracerTransmit() {
        return this.sofaTracerTransmit;
    }
}

