/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.StringUtils;

public class NumberUtils {
    public static <T> T parseNumber(String text, Class<T> targetClass) {
        Assert.notNull((Object)text, "Text must not be null");
        Assert.notNull(targetClass, "Target class must not be null");
        String trimmed = NumberUtils.trimAllWhitespace(text);
        if (Byte.class == targetClass || Byte.TYPE == targetClass) {
            return (T)(NumberUtils.isHexNumber(trimmed) ? Byte.decode(trimmed) : Byte.valueOf(trimmed));
        }
        if (Short.class == targetClass || Short.TYPE == targetClass) {
            return (T)(NumberUtils.isHexNumber(trimmed) ? Short.decode(trimmed) : Short.valueOf(trimmed));
        }
        if (Integer.class == targetClass || Integer.TYPE == targetClass) {
            return (T)(NumberUtils.isHexNumber(trimmed) ? Integer.decode(trimmed) : Integer.valueOf(trimmed));
        }
        if (Long.class == targetClass || Long.TYPE == targetClass) {
            return (T)(NumberUtils.isHexNumber(trimmed) ? Long.decode(trimmed) : Long.valueOf(trimmed));
        }
        if (BigInteger.class == targetClass) {
            return (T)(NumberUtils.isHexNumber(trimmed) ? NumberUtils.decodeBigInteger(trimmed) : new BigInteger(trimmed));
        }
        if (Float.class == targetClass || Float.TYPE == targetClass) {
            return (T)Float.valueOf(trimmed);
        }
        if (Double.class == targetClass || Double.TYPE == targetClass) {
            return (T)Double.valueOf(trimmed);
        }
        if (BigDecimal.class == targetClass || Number.class == targetClass) {
            return (T)new BigDecimal(trimmed);
        }
        throw new IllegalArgumentException("Cannot convert String [" + text + "] to target class [" + targetClass.getName() + "]");
    }

    private static boolean isHexNumber(String value) {
        int index = value.startsWith("-") ? 1 : 0;
        return value.startsWith("0x", index) || value.startsWith("0X", index) || value.startsWith("#", index);
    }

    private static BigInteger decodeBigInteger(String value) {
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (value.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (value.startsWith("0x", index) || value.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (value.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (value.startsWith("0", index) && value.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        BigInteger result = new BigInteger(value.substring(index), radix);
        return negative ? result.negate() : result;
    }

    public static String trimAllWhitespace(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(str.length());
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static Object numberToBytes(Number number) {
        if (number instanceof Byte) {
            return Byte.toString(number.byteValue()).getBytes();
        }
        if (number instanceof Double) {
            return Double.toString(number.doubleValue()).getBytes();
        }
        if (number instanceof Float) {
            return Float.toString(number.floatValue()).getBytes();
        }
        if (number instanceof Integer) {
            return Float.toString(number.intValue()).getBytes();
        }
        if (number instanceof Long) {
            return Long.toString(number.longValue()).getBytes();
        }
        if (number instanceof Short) {
            return Short.toString(number.shortValue()).getBytes();
        }
        if (number instanceof BigDecimal) {
            return ((BigDecimal)BigDecimal.class.cast(number)).toString().getBytes();
        }
        return number;
    }
}

