/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting;

import com.alipay.remoting.CommandFactory;
import com.alipay.remoting.Connection;
import com.alipay.remoting.InvokeCallback;
import com.alipay.remoting.InvokeContext;
import com.alipay.remoting.InvokeFuture;
import com.alipay.remoting.Protocol;
import com.alipay.remoting.ProtocolCode;
import com.alipay.remoting.ProtocolManager;
import com.alipay.remoting.RemotingCommand;
import com.alipay.remoting.TimerHolder;
import com.alipay.remoting.Url;
import com.alipay.remoting.exception.RemotingException;
import com.alipay.remoting.log.BoltLoggerFactory;
import com.alipay.remoting.util.RemotingUtil;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public abstract class BaseRemoting {
    private static final Logger LOGGER = BoltLoggerFactory.getLogger("CommonDefault");
    private static final long ABANDONING_REQUEST_THRESHOLD = 0L;
    protected CommandFactory commandFactory;

    public BaseRemoting(CommandFactory commandFactory) {
        this.commandFactory = commandFactory;
    }

    protected RemotingCommand invokeSync(final Connection conn, RemotingCommand request, int timeoutMillis) throws RemotingException, InterruptedException {
        int remainingTime = this.remainingTime(request, timeoutMillis);
        if ((long)remainingTime <= 0L) {
            LOGGER.warn("already timeout before writing to the network, requestId: {}, remoting address: {}", (Object)request.getId(), conn.getUrl() != null ? conn.getUrl() : RemotingUtil.parseRemoteAddress(conn.getChannel()));
            return this.getCommandFactory(conn).createTimeoutResponse(conn.getRemoteAddress());
        }
        final InvokeFuture future = this.createInvokeFuture(request, request.getInvokeContext());
        conn.addInvokeFuture(future);
        final int requestId = request.getId();
        InvokeContext invokeContext = request.getInvokeContext();
        if (null != invokeContext) {
            invokeContext.put("bolt.invoke.client.before.send", System.nanoTime());
        }
        try {
            conn.getChannel().writeAndFlush((Object)request).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture f) throws Exception {
                    if (!f.isSuccess()) {
                        conn.removeInvokeFuture(requestId);
                        future.putResponse((RemotingCommand)BaseRemoting.this.getCommandFactory(conn).createSendFailedResponse(conn.getRemoteAddress(), f.cause()));
                        LOGGER.error("Invoke send failed, id={}", (Object)requestId, (Object)f.cause());
                    }
                }
            });
            if (null != invokeContext) {
                invokeContext.put("bolt.invoke.client.after.send", System.nanoTime());
            }
        }
        catch (Exception e) {
            conn.removeInvokeFuture(requestId);
            future.putResponse((RemotingCommand)this.getCommandFactory(conn).createSendFailedResponse(conn.getRemoteAddress(), e));
            LOGGER.error("Exception caught when sending invocation, id={}", (Object)requestId, (Object)e);
        }
        RemotingCommand response = future.waitResponse(remainingTime);
        if (null != invokeContext) {
            invokeContext.put("bolt.invoke.client.received", System.nanoTime());
        }
        if (response == null) {
            conn.removeInvokeFuture(requestId);
            response = this.getCommandFactory(conn).createTimeoutResponse(conn.getRemoteAddress());
            LOGGER.warn("Wait response, request id={} timeout!", (Object)requestId);
        }
        return response;
    }

    protected void invokeWithCallback(final Connection conn, RemotingCommand request, InvokeCallback invokeCallback, int timeoutMillis) {
        InvokeFuture future = this.createInvokeFuture(conn, request, request.getInvokeContext(), invokeCallback);
        int remainingTime = this.remainingTime(request, timeoutMillis);
        if ((long)remainingTime <= 0L) {
            LOGGER.warn("already timeout before writing to the network, requestId: {}, remoting address: {}", (Object)request.getId(), conn.getUrl() != null ? conn.getUrl() : RemotingUtil.parseRemoteAddress(conn.getChannel()));
            future.putResponse((RemotingCommand)this.getCommandFactory(conn).createTimeoutResponse(conn.getRemoteAddress()));
            future.tryAsyncExecuteInvokeCallbackAbnormally();
            return;
        }
        conn.addInvokeFuture(future);
        final int requestId = request.getId();
        try {
            Timeout timeout = TimerHolder.getTimer().newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    InvokeFuture future = conn.removeInvokeFuture(requestId);
                    if (future != null) {
                        future.putResponse((RemotingCommand)BaseRemoting.this.getCommandFactory(conn).createTimeoutResponse(conn.getRemoteAddress()));
                        future.tryAsyncExecuteInvokeCallbackAbnormally();
                    }
                }
            }, (long)remainingTime, TimeUnit.MILLISECONDS);
            future.addTimeout(timeout);
            conn.getChannel().writeAndFlush((Object)request).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture cf) throws Exception {
                    if (!cf.isSuccess()) {
                        InvokeFuture f = conn.removeInvokeFuture(requestId);
                        if (f != null) {
                            f.cancelTimeout();
                            f.putResponse((RemotingCommand)BaseRemoting.this.getCommandFactory(conn).createSendFailedResponse(conn.getRemoteAddress(), cf.cause()));
                            f.tryAsyncExecuteInvokeCallbackAbnormally();
                        }
                        LOGGER.error("Invoke send failed. The address is {}", (Object)RemotingUtil.parseRemoteAddress(conn.getChannel()), (Object)cf.cause());
                    }
                }
            });
        }
        catch (Exception e) {
            InvokeFuture f = conn.removeInvokeFuture(requestId);
            if (f != null) {
                f.cancelTimeout();
                f.putResponse((RemotingCommand)this.getCommandFactory(conn).createSendFailedResponse(conn.getRemoteAddress(), e));
                f.tryAsyncExecuteInvokeCallbackAbnormally();
            }
            LOGGER.error("Exception caught when sending invocation. The address is {}", (Object)RemotingUtil.parseRemoteAddress(conn.getChannel()), (Object)e);
        }
    }

    protected InvokeFuture invokeWithFuture(final Connection conn, RemotingCommand request, int timeoutMillis) {
        InvokeFuture future = this.createInvokeFuture(request, request.getInvokeContext());
        conn.addInvokeFuture(future);
        int remainingTime = this.remainingTime(request, timeoutMillis);
        if ((long)remainingTime <= 0L) {
            LOGGER.warn("already timeout before writing to the network, requestId: {}, remoting address: {}", (Object)request.getId(), conn.getUrl() != null ? conn.getUrl() : RemotingUtil.parseRemoteAddress(conn.getChannel()));
            future.putResponse((RemotingCommand)this.getCommandFactory(conn).createTimeoutResponse(conn.getRemoteAddress()));
            return future;
        }
        final int requestId = request.getId();
        try {
            Timeout timeout = TimerHolder.getTimer().newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    InvokeFuture future = conn.removeInvokeFuture(requestId);
                    if (future != null) {
                        future.putResponse((RemotingCommand)BaseRemoting.this.getCommandFactory(conn).createTimeoutResponse(conn.getRemoteAddress()));
                    }
                }
            }, (long)remainingTime, TimeUnit.MILLISECONDS);
            future.addTimeout(timeout);
            conn.getChannel().writeAndFlush((Object)request).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture cf) throws Exception {
                    if (!cf.isSuccess()) {
                        InvokeFuture f = conn.removeInvokeFuture(requestId);
                        if (f != null) {
                            f.cancelTimeout();
                            f.putResponse((RemotingCommand)BaseRemoting.this.getCommandFactory(conn).createSendFailedResponse(conn.getRemoteAddress(), cf.cause()));
                        }
                        LOGGER.error("Invoke send failed. The address is {}", (Object)RemotingUtil.parseRemoteAddress(conn.getChannel()), (Object)cf.cause());
                    }
                }
            });
        }
        catch (Exception e) {
            InvokeFuture f = conn.removeInvokeFuture(requestId);
            if (f != null) {
                f.cancelTimeout();
                f.putResponse((RemotingCommand)this.getCommandFactory(conn).createSendFailedResponse(conn.getRemoteAddress(), e));
            }
            LOGGER.error("Exception caught when sending invocation. The address is {}", (Object)RemotingUtil.parseRemoteAddress(conn.getChannel()), (Object)e);
        }
        return future;
    }

    protected void oneway(final Connection conn, RemotingCommand request) {
        int remainingTime;
        if (conn == null) {
            LOGGER.error("conn is null");
            return;
        }
        Url url = conn.getUrl();
        if (url != null && (long)(remainingTime = this.remainingTime(request, url.getConnectTimeout())) <= 0L) {
            LOGGER.warn("already timeout before writing to the network, requestId: {}, remoting address: {}", (Object)request.getId(), conn.getUrl() != null ? conn.getUrl() : RemotingUtil.parseRemoteAddress(conn.getChannel()));
            return;
        }
        try {
            conn.getChannel().writeAndFlush((Object)request).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture f) throws Exception {
                    if (!f.isSuccess()) {
                        LOGGER.error("Invoke send failed. The address is {}", (Object)RemotingUtil.parseRemoteAddress(conn.getChannel()), (Object)f.cause());
                    }
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Exception caught when sending invocation. The address is {}", (Object)RemotingUtil.parseRemoteAddress(conn.getChannel()), (Object)e);
        }
    }

    protected abstract InvokeFuture createInvokeFuture(RemotingCommand var1, InvokeContext var2);

    protected abstract InvokeFuture createInvokeFuture(Connection var1, RemotingCommand var2, InvokeContext var3, InvokeCallback var4);

    @Deprecated
    protected CommandFactory getCommandFactory() {
        LOGGER.warn("The method getCommandFactory() is deprecated. Please use getCommandFactory(ProtocolCode/Connection) instead.");
        return this.commandFactory;
    }

    protected CommandFactory getCommandFactory(Connection conn) {
        ProtocolCode protocolCode = (ProtocolCode)conn.getChannel().attr(Connection.PROTOCOL).get();
        return this.getCommandFactory(protocolCode);
    }

    protected CommandFactory getCommandFactory(ProtocolCode protocolCode) {
        if (protocolCode == null) {
            return this.getCommandFactory();
        }
        Protocol protocol = ProtocolManager.getProtocol(protocolCode);
        if (protocol == null) {
            return this.getCommandFactory();
        }
        return protocol.getCommandFactory();
    }

    private int remainingTime(RemotingCommand request, int timeout) {
        InvokeContext invokeContext = request.getInvokeContext();
        if (invokeContext == null) {
            return timeout;
        }
        Long cost = (Long)invokeContext.get("bolt.client.conn.createtime");
        if (cost == null) {
            return timeout;
        }
        return (int)((long)timeout - cost);
    }
}

