/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.hystrix;

import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.filter.FilterInvoker;
import com.alipay.sofa.rpc.hystrix.FallbackContext;
import com.alipay.sofa.rpc.hystrix.FallbackFactory;
import com.alipay.sofa.rpc.hystrix.SofaHystrixConfig;
import com.alipay.sofa.rpc.hystrix.SofaHystrixInvokable;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.netflix.hystrix.HystrixCommand;
import java.lang.reflect.InvocationTargetException;

public class SofaHystrixCommand
extends HystrixCommand<SofaResponse>
implements SofaHystrixInvokable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SofaHystrixCommand.class);
    private final RpcInternalContext rpcInternalContext = RpcInternalContext.peekContext();
    private final RpcInvokeContext rpcInvokeContext = RpcInvokeContext.peekContext();
    private final FilterInvoker invoker;
    private final SofaRequest request;

    public SofaHystrixCommand(FilterInvoker invoker, SofaRequest request) {
        super(SofaHystrixConfig.loadSetterFactory((ConsumerConfig)invoker.getConfig()).createSetter(invoker, request));
        this.invoker = invoker;
        this.request = request;
    }

    @Override
    public SofaResponse invoke() {
        if (this.isCircuitBreakerOpen() && LOGGER.isWarnEnabled(this.invoker.getConfig().getAppName())) {
            LOGGER.warnWithApp(this.invoker.getConfig().getAppName(), "Circuit Breaker is opened, method: {}#{}", this.invoker.getConfig().getInterfaceId(), this.request.getMethodName());
        }
        return (SofaResponse)this.execute();
    }

    protected SofaResponse run() throws Exception {
        RpcInternalContext.setContext(this.rpcInternalContext);
        RpcInvokeContext.setContext(this.rpcInvokeContext);
        SofaResponse sofaResponse = this.invoker.invoke(this.request);
        if (!sofaResponse.isError()) {
            return sofaResponse;
        }
        return this.getFallback(sofaResponse, null);
    }

    protected SofaResponse getFallback() {
        return this.getFallback(null, this.getExecutionException());
    }

    protected SofaResponse getFallback(SofaResponse response, Throwable t) {
        FallbackFactory fallbackFactory = SofaHystrixConfig.loadFallbackFactory((ConsumerConfig)this.invoker.getConfig());
        if (fallbackFactory == null) {
            return (SofaResponse)super.getFallback();
        }
        Object fallback = fallbackFactory.create(new FallbackContext(this.invoker, this.request, response, t));
        if (fallback == null) {
            return (SofaResponse)super.getFallback();
        }
        try {
            Object fallbackResult = this.request.getMethod().invoke(fallback, this.request.getMethodArgs());
            SofaResponse actualResponse = new SofaResponse();
            actualResponse.setAppResponse(fallbackResult);
            return actualResponse;
        }
        catch (IllegalAccessException e) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("020140007"), e);
        }
        catch (InvocationTargetException e) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("020140007"), e.getTargetException());
        }
    }
}

