/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mock.generator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shenyu.plugin.mock.api.MockRequest;
import org.apache.shenyu.spi.SPI;

@SPI
public interface Generator<T> {
    public String getName();

    default public T generate(String rule, MockRequest mockRequest) {
        List<String> params = this.extractParams(rule);
        return this.doGenerate(params, rule, mockRequest);
    }

    public T doGenerate(List<String> var1, String var2, MockRequest var3);

    public int getParamSize();

    public boolean match(String var1);

    default public String[] getPrefixAndSuffix() {
        return new String[]{"", ""};
    }

    default public List<String> extractParams(String rule) {
        ArrayList<String> params = new ArrayList<String>();
        String[] split = rule.split("(?<!\\\\)\\|");
        if (split.length >= this.getParamSize() + 1) {
            params.addAll(Arrays.stream(split).map(p -> p.replaceAll("\\\\\\|", "|")).skip(1L).collect(Collectors.toList()));
        }
        return params;
    }
}

