/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.client;

import com.qq.tars.client.util.ParseTools;
import com.qq.tars.common.ClientVersion;
import com.qq.tars.common.util.StringUtils;

public final class ServantProxyConfig {
    private String communicatorId;
    private String protocol;
    private String locator;
    private String stat = "tars.tarsstat.StatObj";
    private String objectName;
    private volatile String simpleObjectName;
    private String masterName;
    private volatile String slaveName;
    private String moduleName = "tars-client";
    private boolean enableSet = false;
    private volatile String setDivision = "";
    private volatile String slaveSetName;
    private volatile String slaveSetArea;
    private volatile String slaveSetID;
    private int connections = 4;
    private int connectTimeout = 3000;
    private int syncTimeout = 3000;
    private int asyncTimeout = 3000;
    private int refreshInterval = 60000;
    private int reportInterval = 60000;
    private int checkInterval = 60000;
    private int tryTimeInterval = 30;
    private int minTimeoutInvoke = 20;
    private int frequenceFailInvoke = 50;
    private float frequenceFailRadio = 0.5f;
    private boolean tcpNoDelay = false;
    private String charsetName = "UTF-8";
    private boolean directConnection = false;
    private int minStaticWeightLimit = 10;
    private int maxStaticWeightLimit = 100;
    private int defaultConHashVirtualNodes = 100;

    public ServantProxyConfig(String objectName) {
        this(null, null, objectName);
    }

    ServantProxyConfig(String communicatorId, String locator, String objectName) {
        this(communicatorId, locator, objectName, ParseTools.hasServerNode(objectName));
    }

    private ServantProxyConfig(String communicatorId, String locator, String objectName, boolean directConnection) {
        this.setCommunicatorId(communicatorId);
        this.setLocator(locator);
        this.setObjectName(objectName);
        if (directConnection && StringUtils.isNotEmpty(locator) && locator.startsWith(this.getSimpleObjectName())) {
            this.setDirectConnection(false);
        } else {
            this.setDirectConnection(directConnection);
        }
    }

    public String getCommunicatorId() {
        return this.communicatorId;
    }

    void setCommunicatorId(String communicatorId) {
        this.communicatorId = communicatorId;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getLocator() {
        return this.locator;
    }

    void setLocator(String locator) {
        this.locator = locator;
    }

    public String getStat() {
        return this.stat;
    }

    public void setStat(String stat) {
        this.stat = stat;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
        this.simpleObjectName = ParseTools.parseSimpleObjectName(objectName);
        this.updateSlaveName();
    }

    private void updateSlaveName() {
        String tmpSlaveName = ParseTools.parseSlaveName(this.simpleObjectName);
        this.slaveName = this.enableSet ? String.format("%s.%s%s%s", tmpSlaveName, this.slaveSetName, this.slaveSetArea, this.slaveSetID) : String.format("%s", tmpSlaveName);
    }

    public String getSimpleObjectName() {
        return this.simpleObjectName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName, boolean masterEnableSet, String masterSetDivision) {
        this.moduleName = moduleName;
        this.masterName = masterEnableSet ? String.format("%s.%s@%s", moduleName, masterSetDivision.replaceAll("\\.", ""), ClientVersion.getVersion()) : String.format("%s@%s", moduleName, ClientVersion.getVersion());
    }

    public String getMasterName() {
        return this.masterName;
    }

    public String getSlaveName() {
        return this.slaveName;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        if (connectTimeout > 0) {
            this.connectTimeout = connectTimeout;
        }
    }

    public int getSyncTimeout() {
        return this.syncTimeout;
    }

    public void setSyncTimeout(int syncTimeout) {
        if (syncTimeout > 0) {
            this.syncTimeout = syncTimeout;
        }
    }

    public int getAsyncTimeout() {
        return this.asyncTimeout;
    }

    public void setAsyncTimeout(int asyncTimeout) {
        if (asyncTimeout > 0) {
            this.asyncTimeout = asyncTimeout;
        }
    }

    public boolean isEnableSet() {
        return this.enableSet;
    }

    public void setEnableSet(boolean enableSet) {
        this.enableSet = enableSet;
        this.updateSlaveName();
    }

    public String getSetDivision() {
        return this.setDivision;
    }

    public void setSetDivision(String setDivision) {
        if (StringUtils.isEmpty(setDivision)) {
            return;
        }
        this.setDivision = setDivision;
        String[] tmp = StringUtils.split(setDivision, ".");
        if (tmp != null && tmp.length >= 3) {
            this.slaveSetName = tmp[0];
            this.slaveSetArea = tmp[1];
            this.slaveSetID = tmp[2];
            this.setEnableSet(true);
        } else {
            this.slaveSetName = "";
            this.slaveSetArea = "";
            this.slaveSetID = "";
            this.setEnableSet(false);
        }
        this.updateSlaveName();
    }

    public String getSlaveSetName() {
        return this.slaveSetName;
    }

    public String getSlaveSetArea() {
        return this.slaveSetArea;
    }

    public String getSlaveSetID() {
        return this.slaveSetID;
    }

    public int getMinTimeoutInvoke() {
        return this.minTimeoutInvoke;
    }

    public void setMinTimeoutInvoke(int minTimeoutInvoke) {
        if (minTimeoutInvoke > 0) {
            this.minTimeoutInvoke = minTimeoutInvoke;
        }
    }

    public int getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(int checkInterval) {
        if (checkInterval > 0) {
            this.checkInterval = checkInterval;
        }
    }

    public int getFrequenceFailInvoke() {
        return this.frequenceFailInvoke;
    }

    public void setFrequenceFailInvoke(int frequenceFailInvoke) {
        if (frequenceFailInvoke > 0) {
            this.frequenceFailInvoke = frequenceFailInvoke;
        }
    }

    public float getFrequenceFailRadio() {
        return this.frequenceFailRadio;
    }

    public void setFrequenceFailRadio(float frequenceFailRadio) {
        this.frequenceFailRadio = frequenceFailRadio;
    }

    public int getTryTimeInterval() {
        return this.tryTimeInterval;
    }

    public void setTryTimeInterval(int tryTimeInterval) {
        if (tryTimeInterval > 0) {
            this.tryTimeInterval = tryTimeInterval;
        }
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean isDirectConnection() {
        return this.directConnection;
    }

    private void setDirectConnection(boolean directConnection) {
        this.directConnection = directConnection;
    }

    public int getConnections() {
        return this.connections;
    }

    public void setConnections(int connections) {
        if (connections > 0) {
            this.connections = connections;
        }
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public int getReportInterval() {
        return this.reportInterval;
    }

    public void setReportInterval(int reportInterval) {
        this.reportInterval = reportInterval;
    }

    public int getMaxStaticWeightLimit() {
        return this.maxStaticWeightLimit;
    }

    public void setMaxStaticWeightLimit(int maxStaticWeightLimit) {
        this.maxStaticWeightLimit = maxStaticWeightLimit;
    }

    public int getMinStaticWeightLimit() {
        return this.minStaticWeightLimit;
    }

    public void setMinStaticWeightLimit(int minStaticWeightLimit) {
        this.minStaticWeightLimit = minStaticWeightLimit;
    }

    public int getDefaultConHashVirtualNodes() {
        return this.defaultConHashVirtualNodes;
    }

    public void setDefaultConHashVirtualNodes(int defaultConHashVirtualNodes) {
        this.defaultConHashVirtualNodes = defaultConHashVirtualNodes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.communicatorId == null ? 0 : this.communicatorId.hashCode());
        result = 31 * result + (this.simpleObjectName == null ? 0 : this.simpleObjectName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServantProxyConfig other = (ServantProxyConfig)obj;
        if (this.communicatorId == null ? other.communicatorId != null : !this.communicatorId.equals(other.communicatorId)) {
            return false;
        }
        return !(this.simpleObjectName == null ? other.simpleObjectName != null : !this.simpleObjectName.equals(other.simpleObjectName));
    }

    public String toString() {
        return "ServantProxyConfig{communicatorId='" + this.communicatorId + '\'' + ", protocol='" + this.protocol + '\'' + ", locator='" + this.locator + '\'' + ", stat='" + this.stat + '\'' + ", objectName='" + this.objectName + '\'' + ", simpleObjectName='" + this.simpleObjectName + '\'' + ", masterName='" + this.masterName + '\'' + ", slaveName='" + this.slaveName + '\'' + ", moduleName='" + this.moduleName + '\'' + ", enableSet=" + this.enableSet + ", setDivision='" + this.setDivision + '\'' + ", slaveSetName='" + this.slaveSetName + '\'' + ", slaveSetArea='" + this.slaveSetArea + '\'' + ", slaveSetID='" + this.slaveSetID + '\'' + ", connections=" + this.connections + ", connectTimeout=" + this.connectTimeout + ", syncTimeout=" + this.syncTimeout + ", asyncTimeout=" + this.asyncTimeout + ", refreshInterval=" + this.refreshInterval + ", reportInterval=" + this.reportInterval + ", checkInterval=" + this.checkInterval + ", tryTimeInterval=" + this.tryTimeInterval + ", minTimeoutInvoke=" + this.minTimeoutInvoke + ", frequenceFailInvoke=" + this.frequenceFailInvoke + ", frequenceFailRadio=" + this.frequenceFailRadio + ", tcpNoDelay=" + this.tcpNoDelay + ", charsetName='" + this.charsetName + '\'' + ", directConnection=" + this.directConnection + ", minStaticWeightLimit=" + this.minStaticWeightLimit + ", maxStaticWeightLimit=" + this.maxStaticWeightLimit + ", defaultConHashVirtualNodes=" + this.defaultConHashVirtualNodes + '}';
    }
}

